FTSRC := $(FTDIR)/src


CFLAGS += -DFT2_BUILD_LIBRARY -O2 -I$(FTDIR) -I$(FTSRC) -I$(FTDIR)/include
#CFLAGS += $(FTDIR)/ft2_include.h

CFLAGS	+= -I$(FTDIR)
VPATH   +=  $(FTDIR)

CFLAGS	+= -I$(FTSRC)/base
VPATH   +=  $(FTSRC)/base

CFLAGS	+= -I$(FTSRC)/cff
VPATH   +=  $(FTSRC)/cff

CFLAGS	+= -I$(FTSRC)/type1
VPATH   +=  $(FTSRC)/type1


CFLAGS	+= -I$(FTSRC)/autofit
VPATH   +=  $(FTSRC)/autofit

CFLAGS	+= -I$(FTSRC)/truetype
VPATH   +=  $(FTSRC)/truetype

CFLAGS	+= -I$(FTDIR)/include
VPATH   +=  $(FTDIR)/include

CFLAGS	+= -I$(FTDIR)/mem
VPATH   +=  $(FTDIR)/mem

CFLAGS	+= -I$(FTDIR)/include/freetype
VPATH   +=  $(FTDIR)/include/freetype


CFLAGS	+= -I$(FTDIR)/include/freetype/config
VPATH   +=  $(FTDIR)/include/freetype/config

CFLAGS	+= -I$(FTDIR)/include/freetype/internal
VPATH   +=  $(FTDIR)/include/freetype/internal


#
# DEMO
#
CFLAGS	+= -I$(FTDIR)/freetype_demo
VPATH   +=  $(FTDIR)/freetype_demo


#
# FreeType2 library autofitting module
#
autofit.o: $(FTSRC)/autofit/autofit.c
	$(CC) -c $(CFLAGS) -o $@ $<

#
# FreeType2 library postscript hinting module
#
pshinter.o: $(FTSRC)/pshinter/pshinter.c
	$(CC) -c $(CFLAGS) -o $@ $<

#
# FreeType2 library PS support module
#
psaux.o: $(FTSRC)/psaux/psaux.c
	$(CC) -c $(CFLAGS) -o $@ $<

#
# FreeType2 library PS glyph names module
#
psnames.o: $(FTSRC)/psnames/psnames.c
	$(CC) -c $(CFLAGS) -o $@ $<

#
# FreeType2 library monochrome raster module
#
raster.o: $(FTSRC)/raster/raster.c
	$(CC) -c $(CFLAGS) -o $@ $<

#
# FreeType2 library anti-aliasing raster module
#
smooth.o: $(FTSRC)/smooth/smooth.c
	$(CC) -c $(CFLAGS) -o $@ $<

#
# FreeType2 library 'sfnt' module
#
sfnt.o: $(FTSRC)/sfnt/sfnt.c
	$(CC) -c $(CFLAGS) -o $@ $<

#
# FreeType2 library glyph and image caching system
#
ftcache.o: $(FTSRC)/cache/ftcache.c
	$(CC) -c $(CFLAGS) -o $@ $<

#
# FreeType2 library OpenType font driver
#
cff.o: $(FTSRC)/cff/cff.c
	$(CC) -c $(CFLAGS) -o $@ $<

#
# FreeType2 library TrueType font driver
#
truetype.o: $(FTSRC)/truetype/truetype.c
	$(CC) -c $(CFLAGS) -o $@ $<

#
# FreeType2 library Type1 font driver
#
type1.o: $(FTSRC)/type1/type1.c
	$(CC) -c $(CFLAGS) -o $@ $<

#
# FreeType2 library Type42 font driver
#
type42.o: $(FTSRC)/type42/type42.c
	$(CC) -c $(CFLAGS) -o $@ $<

#
# FreeType2 library CID-keyed Type1 font driver
#
type1cid.o: $(FTSRC)/cid/type1cid.c
	$(CC) -c $(CFLAGS) -o $@ $<

#
# FreeType2 library BDF bitmap font driver
#
bdf.o: $(FTSRC)/bdf/bdf.c
	$(CC) -c $(CFLAGS) -o $@ $<

#
# FreeType2 library PCF bitmap font driver
#
pcf.o: $(FTSRC)/pcf/pcf.c
	$(CC) -c $(CFLAGS) -o $@ $<

#
# FreeType2 library gzip support for compressed PCF bitmap fonts
#
gzip.o: $(FTSRC)/gzip/ftgzip.c
	$(CC) -c $(CFLAGS) -o $@ $<

#
# FreeType2 library compress support for compressed PCF bitmap fonts
#
lzw.o: $(FTSRC)/lzw/ftlzw.c
	$(CC) -c $(CFLAGS) -o $@ $<

#
# FreeType2 library PFR font driver
#
pfr.o: $(FTSRC)/pfr/pfr.c
	$(CC) -c $(CFLAGS) -o $@ $<

#
# FreeType2 library Windows FNT/FON bitmap font driver
#
winfnt.o: $(FTSRC)/winfonts/winfnt.c
	$(CC) -c $(CFLAGS) -o $@ $<

#
# FreeType2 library TrueTypeGX Validator
#
gxvalid.o: $(FTSRC)/gxvalid/gxvalid.c
	$(CC) -c $(CFLAGS) -o $@ $<

#
# FreeType2 library OpenType validator
#
otvalid.o: $(FTSRC)/otvalid/otvalid.c
	$(CC) -c $(CFLAGS) -o $@ $<

#
# Others
#
ttload.o: $(FTSRC)/sfnt/ttload.c
	$(CC) -c $(CFLAGS) -o $@ $<


cffparse.o: $(FTSRC)/sfnt/cffparse.c
	$(CC) -c $(CFLAGS) -o $@ $<

ft2_demo.o: $(FTDIR)/ft2_demo/ft2_demo.c
	$(CC) -c $(CFLAGS) -o $@ $<

ft2_demo2.o: $(FTDIR)/ft2_demo/ft2_demo2.c
	$(CC) -c $(CFLAGS) -o $@ $<


memory_ft2.o: $(FTDIR)/mem/memory_ft2.c
	$(CC) -c $(CFLAGS) -o $@ $<

NimbusRomNo9L-Regu.cff.o: $(FTDIR)/NimbusRomNo9L-Regu.cff.c
	$(CC) -c $(CFLAGS) -o $@ $<

OTHERS := memory_ft2.o # NimbusRomNo9L-Regu.cff.o ft2_demo2.o



BASE = ftsystem.o ftinit.o ftbase.o ftbbox.o ftbdf.o ftbitmap.o      \
	  ftgasp.o ftglyph.o ftlcdfil.o \
	  ftmm.o ftotval.o ftpfr.o ftstroke.o       \
	  ftsynth.o fttype1.o ftwinfnt.o ftxf86.o

DEBUGPPC = ftdebug.o #ttfont.o #ftdebugpure.o

AFITPPC = autofit.o

GXVPPC =

OTVPPC =

PSPPC = psaux.o psnames.o pshinter.o

RASTERPPC = raster.o smooth.o

FONTDPPC = cff.o type1.o type42.o type1cid.o truetype.o\
	   bdf.o pcf.o pfr.o winfnt.o

FT2_OBJS = $(BASE) $(DEBUGPPC) $(AFITPPC) $(PSPPC) $(RASTERPPC) sfnt.o ftcache.o $(FONTDPPC) gzip.o lzw.o \
			$(OTHERS)


OBJS += $(FT2_OBJS)

#SOURCES += $(FTSRC)/autofit/autofit.c \
#$(FTSRC)/pshinter/pshinter.c \
#$(FTSRC)/psaux/psaux.c \
#$(FTSRC)/psnames/psnames.c \
#$(FTSRC)/raster/raster.c \
#$(FTSRC)/smooth/smooth.c \
#$(FTSRC)/sfnt/sfnt.c \
#$(FTSRC)/cache/ftcache.c \
#$(FTSRC)/cff/cff.c \
#$(FTSRC)/truetype/truetype.c \
#$(FTSRC)/type1/type1.c \
#$(FTSRC)/type42/type42.c \
#$(FTSRC)/cid/type1cid.c \
#$(FTSRC)/bdf/bdf.c \
#$(FTSRC)/pcf/pcf.c \
#$(FTSRC)/gzip/ftgzip.c \
#$(FTSRC)/lzw/ftlzw.c \
#$(FTSRC)/pfr/pfr.c \
#$(FTSRC)/winfonts/winfnt.c \
#$(FTSRC)/gxvalid/gxvalid.c \
#$(FTSRC)/otvalid/otvalid.c \
#$(FTSRC)/sfnt/ttload.c \
#$(FTSRC)/sfnt/cffparse.c \
#$(FTDIR)/ft2_demo/ft2_demo.c \
#$(FTDIR)/ft2_demo/ft2_demo2.c \
#$(FTDIR)/mem/memory_ft2.c \
#$(FTDIR)/NimbusRomNo9L-Regu.cff.c \
