#include <ft2build.h>
#include FT_FREETYPE_H

 #include <debugoff.h>
int FT2_main( unsigned char *font )
{
  int psize;
  int error = 0;
  FT_Library library;
  FT_Face face;
  unsigned int ucode;
  FT_UInt glyph_index;
  int row, pixel;
  

  unsigned char fontlib[255] = "/opt/freetype-2.3.9/vera.ttf"; 
//  unsigned char fontlib[255] = "/opt/freetype-2.3.9/Fzxkfw.ttf"; 
//  unsigned char fontlib[255] = "/opt/freetype-2.3.9/JDJYKD.TTF";

//  ucode = strtol(argv[1], NULL, 16);
//  psize = strtol(argv[2], NULL, 10);
////0xFF, 0xFE, 0x38, 0x6C
//	ucode = 0x386c;
	ucode = 0x0042;	
	psize = 16;
	

  printf("unicode +%X size %d\n", ucode, psize);
  
  error = FT_Init_FreeType(&library);
  F( "error = %d\n\n", error );
  if( error )
  	return 1;
  
  error = FT_New_Face(library, fontlib, 0, &face);
  F( "error = %d\n\n", error );
  
  if ( error == FT_Err_Unknown_File_Format )
	{
		F( "FT_Err_Unknown_File_Format\n\n" );
		//Դ򿪺Ͷļ֧ʽ
	}
  else if( error )
  	return 1;
  if( !face )
  	return 1;
  error = FT_Set_Char_Size(
													face,
													0,
													16*64,
													1280,
													1024 );
  F( "face->num_faces = %d\n", face->num_faces );
  	
  error = FT_Set_Pixel_Sizes(
														face,
														0,
														psize );	
  F( "error = %d\n\n", error );
  if( error )
  	return 1;
  
//  if( FT_Init_FreeType(&library) || FT_New_Face(library, fontlib, 0, &face) || FT_Set_Pixel_Sizes(face, psize, 0) )
//  {
//    return 1;
//  }

	
  glyph_index = FT_Get_Char_Index(face, ucode);
  if(glyph_index == 0)
  {
    return 2;
  }
  if(FT_Load_Glyph(face, glyph_index, FT_LOAD_DEFAULT))
  {
    return 3;
  }
  if( FT_Render_Glyph(face->glyph, FT_RENDER_MODE_MONO) )
  {
    return 4;
  }
  printf("bitmap_left=%d\n"
         "bitmap_top=%d\n"
         "bitmap.rows=%d\n"
         "bitmap.width=%d\n"
         "bitmap.pitch=%d\n"
         "bitmap.pixel_mode=%d\n",
         face->glyph->bitmap_left,
         face->glyph->bitmap_top,
         face->glyph->bitmap.rows,
         face->glyph->bitmap.width,
         face->glyph->bitmap.pitch,
         face->glyph->bitmap.pixel_mode);
  printf("\n\n");
  
 /* for(row = 0; row < (face->glyph->bitmap.rows - face->glyph->bitmap_top); ++row)
  {
      for(pixel = 0; pixel < face->glyph->bitmap.width; ++pixel)
      {
        printf("_");
      }
      printf("\n");
  }*/
  for(row = 0; row < face->glyph->bitmap.rows; ++row)
 {
    for(pixel = 0; pixel < face->glyph->bitmap_left; ++pixel)
      printf(" ");
    for(pixel = 0; pixel < face->glyph->bitmap.width; ++pixel)
    {
//      printf("%c", (face->glyph->bitmap.buffer[row * face->glyph->bitmap.pitch + pixel/8] & (0xC0 >> (pixel % 8)))?'O':'_');
      printf("%c", (face->glyph->bitmap.buffer[row * face->glyph->bitmap.pitch + pixel/8] & (0xC0 >> (pixel % 8)))?'.':' ');
    }
    printf("\n");
  }
  return 0;
}



//extern void FT2_Test( void )   
int main( int argc, char *argv[] )
{
	if( argc < 1 )
	{
		printf( "++No pdf file input!\n" );
		return -1;
	}
//	printf( "pdf file name: %s\n", argv[1] );
	int ret = 0;
	ret = FT2_main( argv[1] );
	F( "ret = %d\n\n",  ret );
	return 0;	
}

//
//hellwolf@cocteau#pts/1%J0S2:getbitmap$ ./getbitmap /usr/share/fonts/chinese/TrueType/uming.ttf $(mygetunicode ) 12                                           
//unicode +6C38 size 12
//bitmap_left=0
//bitmap_top=10
//bitmap.rows=11
//bitmap.width=11
//bitmap.pitch=2
//bitmap.pixel_mode=1
//
//
//___________
//____OOO____
//______OO___
//__OOOOO____
//_____OO_OO_
//OOOOOOO_O__
//___OOOOO___
//___OOOOO___
//__OO_OO_O__
//_OOOOOO_OO_
//OO__OOO_OOO
//O___OO___OO
