/* vim:set ts=4 sw=4 cindent ignorecase enc=gbk: */

#ifndef _TTFONT_H_
#define _TTFONT_H_

//#include <pspkernel.h>
//#include <malloc.h>
//#include <ft2build.h>
//#include FT_FREETYPE_H
#include <ft2build.h> 
#include <datatype.h>

#define SBIT_HASH_SIZE (256)

typedef struct Cache_Bitmap_
{
	int width;
	int height;
	int left;
	int top;
	char format;
	short max_grays;
	int pitch;
	unsigned char *buffer;
} Cache_Bitmap;

typedef struct SBit_HashItem_
{
	unsigned long ucs_code;
	int glyph_index;
	int size;
	BOOL anti_alias;
	BOOL cleartype;
	BOOL embolden;
	int xadvance;
	int yadvance;
	Cache_Bitmap bitmap;
} SBit_HashItem;

typedef struct _ttf
{
	FT_Library library;
	FT_Face face;

	char *fontName;
	BOOL antiAlias;
	BOOL cleartype;
	BOOL embolden;
	int pixelSize;

	SBit_HashItem sbitHashRoot[SBIT_HASH_SIZE];
	int cacheSize;
	int cachePop;

	int fileSize;
	byte *fileBuffer;
} t_ttf, *p_ttf;

extern p_ttf ttf_open(const char *filename, int size);
extern p_ttf ttf_open_buffer(void *buf, size_t length, int pixelsize,
							 const char *ttfname);
extern void ttf_close(p_ttf ttf);
extern BOOL ttf_set_pixel_size(p_ttf ttf, int size);
extern void ttf_set_anti_alias(p_ttf ttf, BOOL cleartype);
extern void ttf_set_cleartype(p_ttf ttf, BOOL aa);
extern void ttf_set_embolden(p_ttf ttf, BOOL embolden);

extern int ttf_get_string_width(p_ttf cttf, p_ttf ettf, const byte * str,
								dword maxpixels, dword wordspace);
extern int ttf_get_string_width_hard(p_ttf cttf, p_ttf ettf, const byte * str,
									 dword maxpixels, dword wordspace);
extern void ttf_load_ewidth(p_ttf ttf, byte * ewidth, int size);
#endif
