#include <plug_jpeg.h>
#include <Macro.h>
#include <datatype.h>
#include <fs_api.h>
#include <jpeglib.h>
#include <strsafe.h>
#include <scene_image.h>
#include <image.h>
#include <debugoff.h>

struct my_error_mgr {
  struct jpeg_error_mgr pub;
  jmp_buf setjmp_buffer;
};
struct JPEG_img img_in;
int jpeg_in_zip_Flag = false;

bool ViewJpegZipFlag = false;

//----------------------------------------------
static int srcleft,srctop,srcw,srch;

//----------------------------------------------
static	int zoom_w, zoom_h;
static	int zoom_w_org, zoom_h_org;
static	int BufferDstLine_Out = 0;//Ѿн
static	pixel *pImgSrc[3] = { NULL, NULL, NULL };//ŵָ
static  dword ImgSrcId = 0;
static  dword ImgSrcMax = 0;

//----------------------------
static	pixel *Vram = NULL;
static	pixel *VramLinePtr = NULL;
static	pixel *VramPtr = NULL;
static	int start_x_up = 0;
static	int dstLine_done_h_up = 0;
static	int dstLine_done_h_old_up = 0;
static	int dstLine_done_h_old_prev_up = 0;
static	int dstLine_done_h_up_max = 0;
static	int src_do_h_up = 0;
static	int srcstart_line_up = 0;//ŵԭʼʼ
static	int srcstart_line_old_up = 0;//ŵԭʼʼ
static	pixel *imgzoomsrcptr_up[2] = { NULL, NULL };//ŵָ(2)
static  pixel *pImgUpLine = NULL;
static	int start_pixelX = 0;
static	int end_pixelX = 0;
static	PAINT_RECT Prect;

//----------------------------
static	pixel *Thumbimg = NULL;
static	int start_x = 0;
static	int dstLine_done_h = 0;
static	int dstLine_done_h_old = 0;
static	int dstLine_done_h_old_prev = 0;
static	int src_do_h = 0;
static	int srcstart_line = 0;//ŵԭʼʼ
static	int srcstart_line_old = 0;//ŵԭʼʼ
static	pixel *imgzoomsrcptr[2] = { NULL, NULL };//ŵָ(2)
static  pixel *pThumbLine = NULL;

static	dword Thumbw, Thumbh;
static	dword Thumbw_org, Thumbh_org;
static	RECT ThumbR, ThumbSR;

//---------(ˮƽ)-------------------
static	int start_x_v = 0;
static	int dstLine_done_h_v = 0;
static	int dstLine_done_h_old_v = 0;
static	int dstLine_done_h_old_prev_v = 0;
static	int src_do_h_v = 0;
static	int srcstart_line_v = 0;//ŵԭʼʼ
static	int srcstart_line_old_v = 0;//ŵԭʼʼ
static	pixel *imgzoomsrcptr_v[2] = { NULL, NULL };//ŵָ(2)

static	dword Thumbw_v, Thumbh_v;
static	dword Thumbw_org_v, Thumbh_org_v;

//----------------------------------------------
static bool cinfoInit;
static struct jpeg_decompress_struct cinfo;

static int imgWidth;
static int imgHeight;

static int ErrorCode = ERR_UNKNOWN;

//MCU_ROWS_INFO mcu_rows_info;
MCU_ROWS_INFO *mcu_rows_info_tbl = NULL;
int mcu_rows_info_tbl_idx = 0;
bool mcu_rows_info_tbl_ready = false;
bool mcu_rows_info_tbl_saved = false;
bool mcu_rows_info_tbl_mem_ready = false;


int fill_input_buffer_count = 0;//Ա

int MCU_rows_in_scan = 0;
int  MCUs_per_row = 0;
static int jpeg_load_count = 0;
static int MCU_vsize;
static int MCU_hsize;

int MCU_start_col,MCU_end_col;
int MCU_No_start;
int MCU_decompress_rows;

int img_cols_start, img_cols_end;//Ҫʼкһ
int MCU_col_num_Cur = 0;

extern void j_seek( j_decompress_ptr cinfo, long offset, int fromwhere );
static void JpegFree(void);

static void jpeg_error_exit(j_common_ptr cinfo)
{
	return;
}

static void jpeg_error_output(j_common_ptr cinfo)
{
	return;
}

FILE* fopenzip( unsigned int size )
{

}

int fseekzip( unsigned char *stream, long offset, int fromwhere )
{

}

void fclosezip( FILE *stream )
{


}

int freadzip(void *ptr, int size, int nitems, FILE *stream)
{

}

extern int jpeg_read_in_zip( void *fp, dword * pwidth, dword * pheight, pixel ** image_data, pixel * bgcolor, t_image_fread readfn )
{
//-------------------------------------------------------------
	int filelen = imgSize;
	int len_per_read = 0, len_r;
	int bufferSize = 0;
	U8 *bufferPtr = NULL;

//-------------------------------------------------------------
	bufferSize = filelen;
	if( bufferSize > IMAGEZIP_BUF_MAX_LEN )
		bufferSize = IMAGEZIP_BUF_MAX_LEN;
	while( bufferPtr == NULL && ( (bufferSize >= 512) || (filelen < 512) ) )
	{
		bufferPtr = malloc( bufferSize );
		if( bufferPtr == NULL )
		{
			bufferSize >>= 1;
		}
		if( bufferSize == 0 )
			break;
	}

	if( bufferPtr == NULL )
	{
		ErrorCode = ERR_MEM_LACK;
		return -1;
	}
	
	len_per_read = bufferSize;
	if( len_per_read > 512 && len_per_read != filelen )
		len_per_read = len_per_read & (~511);

	FILE *fp_w = fopen_imgZipSwapfile( CONFIG_DIR_JPEGZIP_BUF, "wb" );
	
	if( fp_w == NULL )
	{
		free( bufferPtr );
		ErrorCode = ERR_FILE_OPEN;
		return -1;
	}
	while( filelen > 0 )
	{
		if( filelen >= len_per_read )
			len_r = len_per_read;
		else
			len_r = filelen;
		readfn( (void*)bufferPtr, 1, len_r, (void*)fp );
		fwrite( (unsigned char*)bufferPtr, 1, len_r, fp_w );

		filelen -= len_r;
	}
	fclose( fp_w );
	
	ViewJpegZipFlag = true;
	
	return jpeg_read( imgFileName, pwidth, pheight, image_data, bgcolor );
}

void free_mcu_rows_info()
{
	if( mcu_rows_info_tbl_ready || mcu_rows_info_tbl_mem_ready )
	{
		if( mcu_rows_info_tbl )
		{
			free( mcu_rows_info_tbl );
			mcu_rows_info_tbl = NULL;
		}
	}
	jpeg_load_count = 0;
	mcu_rows_info_tbl_mem_ready = false;
	mcu_rows_info_tbl_ready = false;
	mcu_rows_info_tbl_idx = 0;
}

void GetJpgDecodePara()
{
	dword w,h;
	w = SCREEN_W / config.scale;
}

static void ShowImgGradualUp_Init( dword width, dword height, int curleft, int curtop )
{
		int i;
		dword w;
	//----------------------------
		Vram = GetVram( UP_SCREEN );
		VramLinePtr = Vram;
		VramPtr = Vram;
		dstLine_done_h_up = 0;
		dstLine_done_h_old_up = 0;
		dstLine_done_h_old_prev_up = 0;
		dstLine_done_h_up_max = 0;
		src_do_h_up = 0;
		srcstart_line_old_up = 0;//ŵԭʼʼ
		imgzoomsrcptr_up[0] = NULL;//ŵָ(2)
		imgzoomsrcptr_up[1] = NULL;//ŵָ(2)
		start_pixelX = 0;
		end_pixelX = 0;

		GetZoomPara( width, height, &zoom_w, &zoom_h );
		GetScreenPos( &Prect, zoom_w, zoom_h );

		if( ((dword)config.rotate & 0x1) == 0 )
		{
			zoom_w_org = zoom_w;
			zoom_h_org = zoom_h;
		}
		else
		{
			zoom_w_org = zoom_h;
			zoom_h_org = zoom_w;
		}
		
		if( ((dword)config.rotate & 0x1) == 0 )
		{
			dstLine_done_h_up_max = Prect.h;
		}
		else
		{
			dstLine_done_h_up_max = Prect.w;
		}
		
		VramPtr += Prect.painttop * SCREEN_W;//ʼĻʾָ,ָ1е1
		VramPtr += Prect.paintleft;
		
		switch( (dword)config.rotate )
		{
			case conf_rotate_0:
				
				srcleft = curleft * width / zoom_w_org;
				srctop = curtop * width / zoom_w_org;
				srcw = Prect.w * width / zoom_w_org;
				srch = Prect.h * width / zoom_w_org;
				
				start_x_up = curtop * height;
				start_pixelX = curleft;
				end_pixelX = start_pixelX + Prect.w - 1;
				
				break;
			
			case conf_rotate_90:
				
				srcleft = curtop * width / zoom_w_org;
				srctop = (zoom_h_org - curleft - Prect.w) * width / zoom_w_org;
				srcw = Prect.h * width / zoom_w_org;
				srch = Prect.w * width / zoom_w_org;
				
				start_x_up = (zoom_h_org - curleft - Prect.w) * height;
				start_pixelX = curtop;
				end_pixelX = start_pixelX + Prect.h - 1;
				
				VramPtr += (dstLine_done_h_up_max - 1);//ʼĻʾָ
				
				break;
			
			case conf_rotate_180:

				srcleft = (zoom_w_org - curleft - Prect.w) * width / zoom_w_org;
				srctop = (zoom_h_org - curtop - Prect.h) * width / zoom_w_org;
				srcw = Prect.w * width / zoom_w_org;
				srch = Prect.h * width / zoom_w_org;
				
				start_x_up = (zoom_h_org - curtop - Prect.h) * height;
				start_pixelX = zoom_w_org - curleft - Prect.w;
				end_pixelX = start_pixelX + Prect.w - 1;
				
				VramPtr += (dstLine_done_h_up_max - 1)* SCREEN_W;//ʼĻʾָ
				
				break;
			
			case conf_rotate_270:
				
				srcleft = (zoom_w_org - curtop - Prect.h) * width / zoom_w_org;
				srctop = curleft * width / zoom_w_org;
				srcw = Prect.h * width / zoom_w_org;
				srch = Prect.w * width / zoom_w_org;
				
				start_x_up = curleft * height;
				start_pixelX = zoom_w_org - curtop - Prect.h;
				end_pixelX = start_pixelX + Prect.h - 1;
				
				break;
		}
		
		if( srcleft < 0 )srcleft = 0;
		if( srctop < 0 )srctop = 0;
		if( srcw > width )srcw = width;
		if( srch > height )srch = height;

		if( (config.rotate & 0x1) == 0 )
			w = Prect.w;
		else
			w = Prect.h;
		pImgUpLine = (pixel*)memalign( PIXEL_BYTES, w * PIXEL_BYTES );

		srcstart_line_up = srctop;//ŵԭʼʼ
		BufferDstLine_Out = srctop;//Ѿн
		
		memsetword( Vram, COLOR_BLACK, SCREEN_W * SCREEN_H );

		ImgSrcId = 0;
		for( i=0; i<ImgSrcMax; i++ )
			pImgSrc[i] = (pixel*)memalign( PIXEL_BYTES, width * PIXEL_BYTES );
		for( ; i<3; i++ )
			pImgSrc[i] = NULL;
}

static void ShowImgGradualDown_Init( dword width, dword height )
{
//----------------------------
		Thumbimg = image_getthumbbuffer();
		start_x = 0;
		dstLine_done_h = 0;
		dstLine_done_h_old = 0;
		dstLine_done_h_old_prev = 0;
		src_do_h = 0;
		srcstart_line = 0;//ŵԭʼʼ
		srcstart_line_old = 0;//ŵԭʼʼ

		imgzoomsrcptr[0] = NULL;//ŵָ(2)
		imgzoomsrcptr[1] = NULL;//ŵָ(2)

		GetThumbwh( &Thumbw, &Thumbh, width, height, config.rotate );

		if( ((dword)config.rotate & 0x1) == 0 )
		{
			Thumbw_org = Thumbw;
			Thumbh_org = Thumbh;
		}
		else
		{
			Thumbw_org = Thumbh;
			Thumbh_org = Thumbw;
		}
		
		pThumbLine = (pixel*)memalign( PIXEL_BYTES, CONFIG_THUMBW * PIXEL_BYTES );

		GetThumbPos( &ThumbR, &ThumbSR, 0, 0, Thumbw, Thumbh, zoom_w, zoom_h );

		memsetword( Thumbimg, COLOR_BLACK, CONFIG_THUMBW * CONFIG_THUMBH );
		scene_printthumbimgBg( COLOR_BLACK );
}

static void ShowImgGradualDownV_Init( dword width, dword height )
{
//----------------------------
		start_x_v = 0;
		dstLine_done_h_v = 0;
		dstLine_done_h_old_v = 0;
		dstLine_done_h_old_prev_v = 0;
		src_do_h_v = 0;
		srcstart_line_v = 0;//ŵԭʼʼ
		srcstart_line_old_v = 0;//ŵԭʼʼ

		imgzoomsrcptr_v[0] = NULL;//ŵָ(2)
		imgzoomsrcptr_v[1] = NULL;//ŵָ(2)

		GetThumbwh( &Thumbw_v, &Thumbh_v, width, height, conf_rotate_90 );

		Thumbw_org_v = Thumbh_v;
		Thumbh_org_v = Thumbw_v;
		
		if( pThumbimgV )
			free( pThumbimgV );
		
		pThumbimgV = (pixel*)memalign( PIXEL_BYTES, Thumbw_org_v * Thumbh_org_v * PIXEL_BYTES );
		
		if( pThumbimgV )
			memsetword( pThumbimgV, COLOR_BLACK, Thumbw_org_v * Thumbh_org_v );
}

static void ShowImgGradual_Init( dword width, dword height, int curleft, int curtop )
{
	ShowImgGradualUp_Init( width, height, curleft, curtop );
	ShowImgGradualDown_Init( width, height );
	ShowImgGradualDownV_Init( width, height );
}

static void ShowImgGradual_Free()
{
	int i;
	for( i=0; i<3; i++ )
	{
		if( pImgSrc[i] )
		{
			free( pImgSrc[i] );
			pImgSrc[i] = NULL;
		}
	}

	if( pThumbLine )
	{
		free( pThumbLine );
		pThumbLine = NULL;
	}

	if( pImgUpLine )
	{
		free( pImgUpLine );
		pImgUpLine = NULL;
	}
}

#define			DISPLAY_COUNT_MAX_UP			8
static void ShowImgGradual_up( dword width, dword height, int imgline_out, pixel *pImgLine, int *endFlag )
{
	static int dis_count = 0;

	if( pImgLine == NULL || *endFlag == true )
		return;

	if( src_do_h_up < 2 )
	{
		if( dstLine_done_h_up < dstLine_done_h_up_max && BufferDstLine_Out >= srcstart_line_up )
		{
			if( BufferDstLine_Out - srcstart_line_up == src_do_h_up )
				imgzoomsrcptr_up[src_do_h_up++] = pImgLine;
			else
			{
				imgzoomsrcptr_up[0] = imgzoomsrcptr_up[1];
				imgzoomsrcptr_up[1] = pImgLine;
				src_do_h_up = 2;
			}
		}
	}
	if( src_do_h_up == 2 )
	{
		//-------------------------------------
		if( (dstLine_done_h_up < dstLine_done_h_up_max) && src_do_h_up == 2 )
		{
			src_do_h_up = 0;

			int i;
			pixel *imgPtr = NULL;
			pixel *imgDstPtr = NULL;

			do{
				srcstart_line_old_up = srcstart_line_up;
				dstLine_done_h_old_prev_up = dstLine_done_h_up;

				if( pImgUpLine && (dword)config.rotate != 0 )
					imgPtr = pImgUpLine;
				else
					imgPtr = VramPtr;

				srcstart_line_up = image_zoom_bilinear_Line_FromBuffer2( imgzoomsrcptr_up[0], imgzoomsrcptr_up[1], width, height, imgPtr, zoom_w_org, zoom_h_org, start_pixelX, end_pixelX, &dstLine_done_h_up, &start_x_up );

				if( pImgUpLine && (dword)config.rotate != 0 )
				{
					switch((dword)config.rotate )
					{
						case conf_rotate_90:

							imgDstPtr = VramPtr + ( Prect.w - dstLine_done_h_old_prev_up - 1 );
							for( i = 0; i < Prect.h; i++ )
							{
								*imgDstPtr = imgPtr[i];
								imgDstPtr += SCREEN_W;
							}

							break;

						case conf_rotate_180:

							imgDstPtr = VramPtr + ( Prect.h - dstLine_done_h_old_prev_up - 1 ) * Prect.w;
							for( i = Prect.h - 1; i >= 0; i-- )
							{
								*imgDstPtr = imgPtr[i];
								imgDstPtr += 1;
							}
							
							break;

						case conf_rotate_270:
							
							imgDstPtr = VramPtr + dstLine_done_h_old_prev_up;
							for( i = Prect.h - 1; i >= 0; i-- )
							{
								*imgDstPtr = imgPtr[i];
								imgDstPtr += SCREEN_W;
							}
							
							break;
					}
				}
				else
				{
					VramPtr += SCREEN_W;
				}

				if( dstLine_done_h_up >= dstLine_done_h_up_max )
				{
					*endFlag = true;
					break;
				}
			}while( srcstart_line_up == srcstart_line_old_up );
			
			if( (++dis_count >= DISPLAY_COUNT_MAX_UP) || (*endFlag == true) )
			{
				Flush( UP_SCREEN );
				dis_count = 0;
			}
		}
	}
}

static void ShowImgGradual_up2( dword width, dword height, int imgline_out, pixel *pImgLine, int *endFlag )
{
	if( pImgLine == NULL || *endFlag == true )
		return;

	if( src_do_h_up < 2 )
	{
		if( dstLine_done_h_up < dstLine_done_h_up_max && BufferDstLine_Out >= srcstart_line_up )
		{
			if( BufferDstLine_Out - srcstart_line_up == src_do_h_up )
				imgzoomsrcptr_up[src_do_h_up++] = pImgLine;
			else
			{
				imgzoomsrcptr_up[0] = imgzoomsrcptr_up[1];
				imgzoomsrcptr_up[1] = pImgLine;
				src_do_h_up = 2;
			}
		}
	}
	if( src_do_h_up == 2 )
	{
		//-------------------------------------
		if( (dstLine_done_h_up < dstLine_done_h_up_max) && src_do_h_up == 2 )
		{
			src_do_h_up = 0;

			int i;
			pixel *imgPtr = NULL;
			pixel *imgDstPtr = NULL;

			do{
				srcstart_line_old_up = srcstart_line_up;
				dstLine_done_h_old_prev_up = dstLine_done_h_up;

				if( pImgUpLine && (dword)config.rotate != 0 )
					imgPtr = pImgUpLine;
				else
					imgPtr = VramPtr;

				srcstart_line_up = image_zoom_bilinear_Line_FromBuffer2( imgzoomsrcptr_up[0], imgzoomsrcptr_up[1], width, height, imgPtr, zoom_w_org, zoom_h_org, start_pixelX, end_pixelX, &dstLine_done_h_up, &start_x_up );

				if( pImgUpLine && (dword)config.rotate != 0 )
				{
					switch((dword)config.rotate )
					{
						case conf_rotate_90:

							imgDstPtr = VramPtr - dstLine_done_h_old_prev_up;
							for( i = 0; i < Prect.h; i++ )
							{
								*imgDstPtr = imgPtr[i];
								imgDstPtr += SCREEN_W;
							}
							
							break;

						case conf_rotate_180:

							imgDstPtr = VramPtr;
							for( i = Prect.w - 1; i >= 0; i-- )
							{
								*imgDstPtr = imgPtr[i];
								imgDstPtr += 1;
							}
							VramPtr -= SCREEN_W;
							
							break;

						case conf_rotate_270:
							
							imgDstPtr = VramPtr + dstLine_done_h_old_prev_up;
							for( i = Prect.h - 1; i >= 0; i-- )
							{
								*imgDstPtr = imgPtr[i];
								imgDstPtr += SCREEN_W;
							}
							
							break;
					}
				}
				else
				{
					VramPtr += SCREEN_W;
				}

				if( dstLine_done_h_up >= dstLine_done_h_up_max )
				{
					*endFlag = true;
					break;
				}
			}while( srcstart_line_up == srcstart_line_old_up );
		}
	}
}

#define			DISPLAY_COUNT_MAX_DOWN			4
static void ShowImgGradual_down( dword width, dword height, int imgline_out, pixel *pImgLine )
{
	static int dis_count = 0;

	if( pImgLine == NULL )
		return;

	if( src_do_h < 2 )
	{
		if( BufferDstLine_Out >= srcstart_line )
		{
			if( BufferDstLine_Out - srcstart_line == src_do_h )
				imgzoomsrcptr[src_do_h++] = pImgLine;
			else
			{
				imgzoomsrcptr[0] = imgzoomsrcptr[1];
				imgzoomsrcptr[1] = pImgLine;
				src_do_h = 2;
			}
		}
	}
	if( src_do_h == 2 || BufferDstLine_Out == height )
	{
		src_do_h = 0;
		dstLine_done_h_old = dstLine_done_h;

		int i;
		pixel *thumbimgPtr = NULL;
		pixel *thumbimgDstPtr = NULL;
		do{
			srcstart_line_old = srcstart_line;
			dstLine_done_h_old_prev = dstLine_done_h;

			if( pThumbLine && (dword)config.rotate != 0 )
				thumbimgPtr = pThumbLine;
			else
				thumbimgPtr = Thumbimg + dstLine_done_h_old_prev * Thumbw;

			srcstart_line = image_zoom_bilinear_Line_FromBuffer( imgzoomsrcptr[0], imgzoomsrcptr[1], width, height, thumbimgPtr, Thumbw_org, Thumbh_org, &dstLine_done_h, &start_x );

			if( pThumbLine && (dword)config.rotate != 0 )
			{
				switch((int)config.rotate )
				{
					case conf_rotate_90:
						thumbimgDstPtr = Thumbimg + ( Thumbw - dstLine_done_h_old_prev - 1 );
						for( i = 0; i < Thumbw_org; i++ )
						{
							*thumbimgDstPtr = thumbimgPtr[i];
							thumbimgDstPtr += Thumbw;
						}
						break;

					case conf_rotate_180:
						thumbimgDstPtr = Thumbimg + Thumbw *( Thumbh - dstLine_done_h_old_prev );
						for( i = 0; i < Thumbw_org; i++ )
						{
							*thumbimgDstPtr = thumbimgPtr[i];
							thumbimgDstPtr -= 1;
						}
						break;

					case conf_rotate_270:
						thumbimgDstPtr = Thumbimg + Thumbw *( Thumbh - 1 ) + dstLine_done_h_old_prev;
						for( i = 0; i < Thumbw_org; i++ )
						{
							*thumbimgDstPtr = thumbimgPtr[i];
							thumbimgDstPtr -= Thumbw;
						}
						break;
				}
			}


		}while( srcstart_line == srcstart_line_old );

		scene_printthumbimgline( ThumbR, ThumbSR, dstLine_done_h_old, dstLine_done_h - dstLine_done_h_old );
//		scene_printthumbimg( 0, 0, Thumbw, Thumbh, zoom_w, zoom_h, Thumbimg );

		if( ++dis_count >= DISPLAY_COUNT_MAX_DOWN )
		{
			Flush( DOWN_SCREEN );
			dis_count = 0;
		}
	}
}


static void ShowImgGradual_downV( dword width, dword height, int imgline_out, pixel *pImgLine )
{
	if( pImgLine == NULL )
		return;

	if( pThumbimgV == NULL )
		return;
		
	if( pThumbLine == NULL )
		return;
	
	if( src_do_h_v < 2 )
	{
		if( BufferDstLine_Out >= srcstart_line_v )
		{
			if( BufferDstLine_Out - srcstart_line_v == src_do_h_v )
				imgzoomsrcptr_v[src_do_h_v++] = pImgLine;
			else
			{
				imgzoomsrcptr_v[0] = imgzoomsrcptr_v[1];
				imgzoomsrcptr_v[1] = pImgLine;
				src_do_h_v = 2;
			}
		}
	}
	if( src_do_h_v == 2 || BufferDstLine_Out == height )
	{
		src_do_h_v = 0;
		dstLine_done_h_old_v = dstLine_done_h_v;

		int i;
		pixel *thumbimgPtr = NULL;
		pixel *thumbimgDstPtr = NULL;
		do{
			srcstart_line_old_v = srcstart_line_v;
			dstLine_done_h_old_prev_v = dstLine_done_h_v;

			thumbimgPtr = pThumbLine;

			srcstart_line_v = image_zoom_bilinear_Line_FromBuffer( imgzoomsrcptr_v[0], imgzoomsrcptr_v[1], width, height, thumbimgPtr, Thumbw_org_v, Thumbh_org_v, &dstLine_done_h_v, &start_x_v );

			//conf_rotate_90
			thumbimgDstPtr = pThumbimgV + ( Thumbh_org_v - dstLine_done_h_old_prev_v - 1 );
			for( i = 0; i < Thumbw_org_v; i++ )
			{
				*thumbimgDstPtr = thumbimgPtr[i];
				thumbimgDstPtr += Thumbw_v;
			}
			
		}while( srcstart_line_v == srcstart_line_old_v );
	}
}

//------------------------------------------------------------------
//------------------------------------------------------------------
/*******************************************/
int read_JPEG( FILE *infile, struct JPEG_img *jpeg_img, int curleft, int curtop )
{
	int UpendFlag = false;
	int i,m;
	int rowstride = cinfo.output_width * cinfo.output_components;

	int RetValue = SUCCESSED;
	struct my_error_mgr jerr;
	unsigned char *buffer[1];
	unsigned char magicno[3];

	if( jpeg_in_zip_Flag == false )
	{
		fseek(infile, 0, 0);
		if ((i=fread(magicno, (size_t) 1, (size_t) 3, infile)) < 3) return(FAILED);
	}
	else
	{
		fseekzip( infile, 0, 0 );
		if ((i=freadzip(magicno, (size_t) 1, (size_t) 3, infile)) < 3) return(FAILED);
	}
  	if (magicno[0]!=0xff||magicno[1]!=0xd8||magicno[2]!=0xff) return(FAILED);

  	if( jpeg_in_zip_Flag == false )
  		fseek(infile, 0, 0);
	else
		fseekzip(infile, 0, 0);
  /* Step 1: allocate and initialize JPEG compression object */

	cinfo.err = jpeg_std_error(&jerr.pub);
	jerr.pub.error_exit     = jpeg_error_exit;
	jerr.pub.output_message = jpeg_error_output;

  	jpeg_create_decompress(&cinfo);

  /* Step 2: specify data destination (eg, a file) */
  	jpeg_stdio_src(&cinfo, infile);

  /* Step 3: read file parameters with jpeg_read_header() */
  	(void) jpeg_read_header(&cinfo, TRUE);

  /* Step 4: set parameters for decompression */
  /* do various cleverness regarding decompression parameters & such... */
	jpeg_calc_output_dimensions(&cinfo);
  	jpeg_img->width  = cinfo.output_width;
  	jpeg_img->height = cinfo.output_height;
  	imgWidth = cinfo.output_width;
  	imgHeight = cinfo.output_height;
	if (cinfo.jpeg_color_space == JCS_GRAYSCALE)
	{
		cinfo.out_color_space = JCS_GRAYSCALE;
		cinfo.quantize_colors = FALSE;
	}
	else
	{
		cinfo.out_color_space = JCS_RGB;
		cinfo.quantize_colors = FALSE;     /* default: give 24-bit image to XV */
	}

//	jpeg_calc_output_dimensions(&cinfo);   /* note colorspace changes... */
	rowstride = cinfo.output_width * cinfo.output_components;

	if (cinfo.output_components != 1 && cinfo.output_components != 3)//8λ24λ
	{
		jpeg_destroy_decompress(&cinfo);
		if( jpeg_in_zip_Flag == false )
			fclose(infile);
		else
			fclosezip( infile );
		return FAILED;
	}

  /* Step 5: Start decompressor */
  	jpeg_start_decompress(&cinfo);

  /* Step 6: while (scan lines remain to be read) */
  /*           jpeg_read_scanlines(...); */

  /* Make a one-row-high sample array that will go away when done with image */
	buffer[0] = malloc( rowstride );
	if( buffer[0] == NULL )
		goto _read_JPEG_Exit;

	PAINT_RECT Prect;

	if( mcu_rows_info_tbl_ready == false )
	{
		ImgSrcMax = 3;
		scene_printimgInfo( imgWidth, imgHeight );
		ShowImgGradual_Init( imgWidth, imgHeight, curleft, curtop );
	}
	else
	{
		ImgSrcMax = 2;
		ShowImgGradualUp_Init( imgWidth, imgHeight, curleft, curtop );
	}

	U8 r,g,b;
	int startLine = 0, endLine;

	MCU_vsize = cinfo.max_v_samp_factor << 3;
  	MCU_hsize = cinfo.max_h_samp_factor << 3;
  	MCU_rows_in_scan = cinfo.MCU_rows_in_scan;
  	MCUs_per_row = cinfo.MCUs_per_row;

	if( mcu_rows_info_tbl_ready == false && mcu_rows_info_tbl_mem_ready == false )
	{
		mcu_rows_info_tbl = (MCU_ROWS_INFO*)malloc( MCUs_per_row * MCU_rows_in_scan * sizeof(MCU_ROWS_INFO) );

		if( mcu_rows_info_tbl )
		{
			memsetdword( mcu_rows_info_tbl, 0, MCUs_per_row * MCU_rows_in_scan * sizeof( MCU_ROWS_INFO ) / 4 );
			mcu_rows_info_tbl_mem_ready = true;
			mcu_rows_info_tbl_idx = 0;
		}
		else
		{
			mcu_rows_info_tbl_mem_ready = true;
			free_mcu_rows_info();
		}
	}

	if( mcu_rows_info_tbl_ready == true )
	{
		fill_input_buffer_count = 0; //Ա
		int startMCURow = srctop / MCU_vsize;
		MCU_start_col = srcleft / MCU_hsize;
		MCU_end_col = (srcleft + srcw) / MCU_hsize;
		if( MCU_start_col >= cinfo.MCUs_per_row )MCU_start_col = cinfo.MCUs_per_row - 1;
		if( MCU_end_col >= cinfo.MCUs_per_row )MCU_end_col = cinfo.MCUs_per_row - 1;

#if 1
		MCU_No_start = startMCURow * MCUs_per_row + MCU_start_col;
#else
		MCU_No_start = startMCURow * MCUs_per_row;
		j_set_MCU_info( &cinfo, MCU_No_start );
#endif

		startLine = srctop % MCU_vsize;
		endLine = startLine + srch;
		img_cols_start = srcleft;
		img_cols_end = img_cols_start + srcw + 1;
		if( img_cols_start > imgWidth )img_cols_start = imgWidth;
		if( img_cols_end > imgWidth )img_cols_end = imgWidth;
		
		MCU_decompress_rows = 0;
		
		MCU_col_num_Cur = 0;
	}
	else
	{
		startLine = 0;
		endLine = cinfo.output_height;
		
		MCU_start_col = 0;
		MCU_end_col = cinfo.MCUs_per_row - 1;

		img_cols_start = 0;
		img_cols_end = imgWidth;
	}

	while ( cinfo.output_scanline < endLine )
  	{
		(void) jpeg_read_scanlines(&cinfo, buffer, 1);//buffer: ָ룬һάָ룬ָ

	    /* Assume put_scanline_someplace wants a pointer and sample count. */
		if (cinfo.out_color_space == JCS_GRAYSCALE)
	    {
		}
	   	else
	   	{
	   		if( mcu_rows_info_tbl_ready == false && 1)
	   		{
	   			int doup_Flag = 0;
	   			int dodown_Flag = 0;
	   			int dodownV_Flag = 0;

	   			if( src_do_h_up < 2 && BufferDstLine_Out >= srcstart_line_up )
	   				doup_Flag = 1;

	   			if( src_do_h < 2 && BufferDstLine_Out >= srcstart_line )
	   				dodown_Flag = 1;
	   				
	   			if( src_do_h_v < 2 && BufferDstLine_Out >= srcstart_line_v )
	   				dodownV_Flag = 1;
	   			
	   			if( doup_Flag || dodown_Flag || dodownV_Flag )
	   			{
	   				ImgSrcId++;
	   				if( ImgSrcId >= ImgSrcMax )
	   					ImgSrcId = 0;
		   			for ( i= 0,m = 0; i < imgWidth; i++ )
					{
						r = buffer[0][m++];//ΪbufferĶάָ룬Լ[0]ʾһ
						g = buffer[0][m++];
						b = buffer[0][m++];
						r >>= 3;
						g >>= 3;
						b >>= 3;
						pImgSrc[ImgSrcId][i] = RGB15( r,g,b );
					}
	   			}

	   			if( doup_Flag )
	   			{
	   				ShowImgGradual_up( imgWidth, imgHeight, BufferDstLine_Out, pImgSrc[ImgSrcId], &UpendFlag );
	   			}

	   			if( dodown_Flag )
	   			{
					ShowImgGradual_down( imgWidth, imgHeight, BufferDstLine_Out, pImgSrc[ImgSrcId] );
				}
				
				if( dodownV_Flag )
				{
					ShowImgGradual_downV( imgWidth, imgHeight, BufferDstLine_Out, pImgSrc[ImgSrcId] );	
				}
	   		}
	   		else
	   		{
				if( cinfo.output_scanline < startLine )
					continue;
				
				int doup_Flag = 0;
				
	   			if(  src_do_h_up < 2 && BufferDstLine_Out >= srcstart_line_up )
	   				doup_Flag = 1;

	   			if( doup_Flag )
	   			{
	   				ImgSrcId++;
	   				if( ImgSrcId >= ImgSrcMax )
	   					ImgSrcId = 0;
	   				memsetword( pImgSrc[ImgSrcId], 0, imgWidth );
		   			for ( i= srcleft,m = srcleft*3; i < (srcleft+srcw); i++ )
					{
						r = buffer[0][m++];//ΪbufferĶάָ룬Լ[0]ʾһ
						g = buffer[0][m++];
						b = buffer[0][m++];
						r >>= 3;
						g >>= 3;
						b >>= 3;
						pImgSrc[ImgSrcId][i] = RGB15( r,g,b );
					}
	   			}

	   			if( doup_Flag && 1)
	   			{
	   				ShowImgGradual_up2( imgWidth, imgHeight, BufferDstLine_Out, pImgSrc[ImgSrcId], &UpendFlag );
	   			}
			}
		}
		BufferDstLine_Out++;
	}
	if( buffer[0] )
	{
		free( buffer[0] );
		buffer[0] = NULL;
	}

_read_JPEG_Exit:

	if( mcu_rows_info_tbl_mem_ready )
		mcu_rows_info_tbl_ready = true;

	if( mcu_rows_info_tbl_ready && mcu_rows_info_tbl_saved == false && 0 )
	{
		char imgdat_name[IMGDAT_NAME_LEN];
		STRCPY_S( imgdat_name, CONFIG_EBOOK_ROOTDIR );
		STRCAT_S( imgdat_name, "mcu_info_tbl3.$$$" );
		FILE *fp_tbl = fopen( imgdat_name, "wb" );

		if( fp_tbl )
		{
			fwrite( mcu_rows_info_tbl, 1, MCUs_per_row * MCU_rows_in_scan * sizeof( MCU_ROWS_INFO ), fp_tbl );
			fclose( fp_tbl );
			mcu_rows_info_tbl_saved = true;
		}
	}
	ShowImgGradual_Free();

//	return SUCCESSED;
  /* Step 7: Finish decompression */
  jpeg_finish_decompress(&cinfo);

  /* Step 8: Release JPEG decompression object */
  jpeg_destroy_decompress(&cinfo);
  return RetValue;
}

int main_jpeg( char *filename, int curleft, int curtop )
{
  	FILE *fin;

	if( !filename )return -1;

  	if((fin = fopen( filename, "rb")) == NULL)
  	{
		return -1;
  	}
  	if (read_JPEG( fin, &img_in, curleft, curtop ) == FAILED)
  	{
    	fclose(fin);
    	return -1;
  	}
  	fclose(fin);
  	return 0;
}

void PlugJpeg_GetBitmap( char *filename, int curleft, int curtop )
{
//	return;
	if( jpeg_load_count == 0 )
	{
		jpeg_load_count++;
		return;
	}
	main_jpeg( filename, curleft, curtop );
	JpegFree();
	return;
}

//int curleft, int curtop, int destw, int desth, int paintleft, int painttop, int srcwidth, int srcheight, int destwidth, int destheight
extern int jpeg_read( const char *filename, dword * pwidth, dword * pheight, pixel ** image_data, pixel * bgcolor )
{
//---------------------
	if( main_jpeg( filename, 0, 0 ) != 0 )
		return -1;

	*pwidth = img_in.width;
	*pheight = img_in.height;
	*bgcolor = COLOR_BLACK;//Ϊɫ

	JpegFree();

	return 0;
}

static void free_img(void **pt)
{
	savefree( (void *)pt[0]);
	savefree( (void *)pt);
}

void free_JPEG (struct JPEG_img *img)
{
  int			i;
  if (img->jpeg_type == 'g')
  {
    free_img ((void **)img->mono);
  }
  else
  {
    if (img->jpeg_type == 'c')
    {
      for (i = 0; i < 3; i++) free_img ((void **)img->color[i]);
      savefree((void *)img->color);
    }
    else
      dprintf("\nWarning: input structure to free routine is invalid\n");
  }
}


static void JpegFree(void)
{
  if(cinfoInit==true){
     /* Step 7: Finish decompression */
  jpeg_finish_decompress(&cinfo);
  /* Step 8: Release JPEG decompression object */
  jpeg_destroy_decompress(&cinfo);
    cinfoInit=false;
  }

  free_JPEG( &img_in );

//  if(imgCmpBuf!=NULL){
//    safefree(imgCmpBuf); imgCmpBuf=NULL;
//  }
}