#ifndef __PLUG_JPEG_H
#define __PLUG_JPEG_H

#include <datatype.h>
#include <MemMgr.h>
#include <display.h>  
//#include <memory_jpeg.h>
#include <gdi.h>
#include <image.h>
#include <DrvMemMgr.h>
#include <fs_api.h>
#include <conf.h>
#include <scene.h>


#define SUCCESSED	0
#define FAILED		1

struct JPEG_img
{
  int			height;
  int			width;
  char			jpeg_type;  /* 'c' = color; 'g' = graymap;  */
  unsigned char		**mono;
  unsigned char		***color;
};

#define			LAST_DC_VAL_LEN				3

#if 1
typedef struct {
	unsigned int offset;
	unsigned int get_buffer;
	short int last_dc_val[LAST_DC_VAL_LEN];//4 /* JPEG limit on # of components in one scan *///з
//	unsigned short int bits_left;
	unsigned char bits_left;//ΪʣλΪ31λֻbits_left4-0λ棬7-5λ渴λ0xd7-0xd0ĵλ
	unsigned char restarts_to_go;
}MCU_ROWS_INFO;//4ֽڶ룬ռ16ֽڴռ

#else

struct last_dc_val_s{
	short int last_dc_val[4];//4 /* JPEG limit on # of components in one scan */
};

typedef struct {
	int *offset_tbl;
	struct last_dc_val_s *last_dc_val_tbl;
//	short int bits_left;
	unsigned char *bits_left_tbl;
}MCU_ROWS_INFO;
#endif

extern MCU_ROWS_INFO *mcu_rows_info_tbl;
extern int mcu_rows_info_tbl_idx;
extern bool mcu_rows_info_tbl_ready;
extern bool mcu_rows_info_tbl_mem_ready;
extern int MCU_rows_in_scan,MCUs_per_row;
extern int MCU_start_col,MCU_end_col,MCU_No_start;
extern int MCU_decompress_rows;

extern int fill_input_buffer_count;//Ա
extern unsigned int unread_marker_tbl_idx;

extern int img_cols_start, img_cols_end;//Ҫʼкһ(к)

extern int jpeg_read_in_zip( void *fp, dword * pwidth, dword * pheight, pixel ** image_data, pixel * bgcolor, t_image_fread readfn );
extern void PlugJpeg_GetBitmap( char *filename, int curleft, int curtop );
void free_mcu_rows_info();
extern int jpeg_read( const char *filename, dword * pwidth, dword * pheight, pixel ** image_data, pixel * bgcolor );

#endif // __PLUG_JPEG_H
