#include "fitz.h"
#include "mupdf.h"
#include "pdfapp.h"
#include <scene.h>
#include <win.h>
#include <strsafe.h>

#include <DrvMemMgr.h>
#include <MemMgr.h>
#include <config_ebook.h>
#include <Macro.h>
#include <display.h>
#include <gdi.h>
#include <image.h>
#include <scene_image.h>
#include <HelpMenu_Pdf.h>
#include <ctrl.h>
#include <key.h>
#include <ds2io2.h>
#include <language.h>
#include <MemMgr.h>
#include <mystring.h>

#include <debugoff.h>

//-------------ȫֱ-----------------------
static pdfapp_t gapp;
pixel *pdfdata = NULL;//pdfʵʿߵ
static char filename[PATH_MAX2];
BOOL pdf_needrp = true;
BOOL pdf_needrf = true;
int pdfh = SCREEN_H;
static U32 pdfFilesize = 0;
static int dis_mode = 0;
static U16 dis_mode_flag = 0;
static int pdf_close_flag = true;
static BOOL needp_mainbg = true;
static BOOL needp_infobg = true;

//-----------------------ȫֱ--------------
extern p_win_menuitem filelist;
extern pixel * bufferMain;
extern pixel * bufferSub;
extern pixel thumbimg[CONFIG_THUMBW * CONFIG_THUMBH];

//-----------------------------------------
void pdf_thumb( void );
int pdf_read2( dword * pWidth, dword * pHeight, pixel **ppPdfData, pixel * pBgColor );

//---------------------------------------------
static void
ximage_convert_bgra8888( const unsigned char *src, int srcstride, pixel *dst, int dststride, int w,  int h )
{
	int x, y;
	unsigned char*s = (unsigned char*)src;
	unsigned char r,g,b;

	for (y = 0; y < h; y++)
	{
		for (x = 0; x < w*4; x += 4 )
		{
			r = s[x+1] >> 3;
			g = s[x+2] >> 3;
			b = s[x+3] >> 3;
			*dst++ = RGB15( r,g,b );
		}
		s += srcstride;
	}
}

void pdf_up(void)
{
	if (curtop > 0)
	{
		curtop -= (int) config.pdfmvspd * 2;
		if (curtop < 0)
			curtop = 0;
		pdf_needrp = true;
	}
}

void pdf_down(void)
{
	if (h2 > pdfh && curtop < h2 - pdfh)
	{
		curtop += (int) config.pdfmvspd * 2;
		if (curtop > h2 - pdfh)
			curtop = h2 - pdfh;
		pdf_needrp = true;
	}
}

void pdf_left( void )
{
	if (curleft > 0)
	{
		curleft -= (int) config.pdfmvspd * 2;
		if (curleft < 0)
			curleft = 0;
		pdf_needrp = true;
	}
}

void pdf_right( void )
{
	if (w_org_r > SCREEN_W && curleft < w_org_r - SCREEN_W)
	{
		curleft += (int) config.pdfmvspd * 2;
		if (curleft > w_org_r - SCREEN_W)
			curleft = w_org_r - SCREEN_W;
		pdf_needrp = true;
	}
}

void pdf_move(dword key)
{
	if (key & KEY_LEFT && !(key & KEY_RIGHT) && !(key & KEY_UP) && !(key & KEY_DOWN))
	{
		pdf_left();
	}
	if (key & KEY_RIGHT && !(key & KEY_LEFT) && !(key & KEY_UP) && !(key & KEY_DOWN))
	{
		pdf_right();
	}
	if (key & KEY_UP && !(key & KEY_DOWN) && !(key & KEY_LEFT) && !(key & KEY_RIGHT))
	{
		pdf_up();
	}
	if (key & KEY_DOWN && !(key & KEY_UP) && !(key & KEY_LEFT) && !(key & KEY_RIGHT))
	{
		pdf_down();
	}
}


void reset_pdf_ptr(void)//ͷpdfshowpdfdataÿ
{
	if (pdfdata != NULL)
	{
		free_pdf((void *) pdfdata);
		pdfdata = NULL;
	}
}

void report_pdf_error(int status)
{
	char infomsg[80];
	const char *errstr;

	switch (status) {
		case 1:
		case 2:
		case 3:
			errstr = lang_item[LANG_WFORMAT_ID];//"ʽ"
			break;
		case 4:
		case 5:
		case 6:
			errstr = lang_item[LANG_MEMLACK_ID];//"ڴ治"
			break;
		default:
			errstr = lang_item[LANG_UNKNOWN_REASON_ID];//""
			break;
	}

	DrawMessageBox( lang_Notice, CENTER_ALIGN, (const char*)infomsg, DOWN_SCREEN, MB_OK | MB_CANCEL, TRUE );
	reset_pdf_ptr();
}


void pdf_dis_mode2( void )
{
	if( ++dis_mode_flag > 4 )
		dis_mode_flag = 0;
	switch( dis_mode_flag )
	{
		case 0: dis_mode = '0';break;//90%
		case 1: dis_mode = '8';break;//80%
		case 2: dis_mode = '6';break;//60%
		case 3: dis_mode = '4';break;//40%
		case 4: dis_mode = '2';break;//20%
	}
	pdfapp_onkey( &gapp, dis_mode );
	reset_pdf_ptr();
}


int pdf_dis_mode( void )
{
	int result = 0;
	pdf_dis_mode2();
	result = pdf_read2( &w_org_r, &h_org_r, &pdfdata, &Bgcolor );
	return result;
}

//--------------------------------------------------------------------------
//
//--------------------------------------------------------------------------
BOOL pdf_resize_scale( int mode )
{
//---------------------------------------------------
	int result = 0;
	int w2_old;
	int h2_old;
	int scale_old;

	w2_old = w2;
	h2_old = h2;
	scale_old = gapp.zoom * 100;

//---------------------------------------------------
	switch( mode )
	{
		case ZOOM_OUT: //С
				pdfapp_onkey( &gapp, '-' );
				break;
		case ZOOM_IN://Ŵ
				pdfapp_onkey( &gapp, '+' );
				break;
		default:
				return false;
	}
	reset_pdf_ptr();
	result = pdf_read2( &w_org_r, &h_org_r, &pdfdata, &Bgcolor );

	int scale = gapp.zoom * 100;

	{
		int w,h;

		if( w2 > SCREEN_W )
		{
			if( w2_old <= SCREEN_W )
			{
				curleft = ( w2 - SCREEN_W ) >> 1;
			}
			else
			{
				w = ( curleft + SCREEN_W / 2 )  * scale / scale_old ;
				curleft = w - SCREEN_W / 2;
				if( curleft < 0 )
				{
					curleft = 0;
				}
				else if( curleft + SCREEN_W > w2 )
				{
					curleft = w2 - SCREEN_W;
				}
			}
		}
		else
		{
			curleft = 0;
		}
		if( h2 > SCREEN_H )
		{
			if( h2_old <= SCREEN_H )
			{
				curtop = ( h2 - SCREEN_H ) >> 1;
			}
			else
			{
				h = ( curtop + SCREEN_H / 2 ) *  scale / scale_old;
				curtop  = h - SCREEN_H / 2;
				if( curtop < 0 )
				{
					curtop = 0;
				}
				else if( curtop + SCREEN_H > h2 )
				{
					curtop = h2 - SCREEN_H;
				}
			}
		}
		else
		{
			curtop = 0;
		}
	}

	return result;
}


BOOL pdf_scale( dword key )
{
	BOOL result = false;
	if( ((key & KEY_A ) && (key & KEY_UP) && (!(key & ~(KEY_A | KEY_UP)))) || ( ( key & KEY_Y ) && (!(key & ~KEY_Y)) ) )//С
	{
		result = pdf_resize_scale( ZOOM_OUT );
	}
	else if( ((key & KEY_A ) && (key & KEY_DOWN) && (!(key & ~(KEY_A | KEY_DOWN)))) || ( ( key & KEY_X ) && (!(key & ~KEY_X)) ) )//Ŵ
	{
		result = pdf_resize_scale( ZOOM_IN );
	}
	return result;
}

//--------------------------------------------------------------------------
//ת
//--------------------------------------------------------------------------
BOOL pdf_rotate2( int mode )
{
//---------------------------------------------------
	int result = 0;

//---------------------------------------------------
	switch( mode )
	{
		case 0: //ʱת
				pdfapp_onkey( &gapp, 'l' );
				break;
		case 1://˳ʱת
				pdfapp_onkey( &gapp, 'r' );
				break;
		default:
				return false;
	}
	reset_pdf_ptr();
	result = pdf_read2( &w_org_r, &h_org_r, &pdfdata, &Bgcolor );
	return result;
}

BOOL pdf_rotate( dword key )
{
	BOOL result = false;
	if( (key & KEY_A ) && (key & KEY_LEFT) && (!(key & ~(KEY_A | KEY_LEFT))) )//С
	{
		result = pdf_rotate2( 0 );//ʱת
	}
	else if( (key & KEY_A ) && (key & KEY_RIGHT) && (!(key & ~(KEY_A | KEY_RIGHT))) )//Ŵ
	{
		result = pdf_rotate2( 1 );//˳ʱת
	}

	pdf_thumb();

	int rotate = gapp.rotate;

	while( rotate >= 360 )
	{
		rotate -= 360;
	}

	while( rotate < 0 )
	{
		rotate += 360;
	}

	if( gapp.rotate != rotate )
		gapp.rotate = rotate;

	switch( rotate )
	{
		case 0:
			curleft = 0;
			curtop  = 0;
			break;
		case 90:
			curleft = w2 - SCREEN_W;
			curtop  = 0;
			break;
		case 180:
			curleft = w2 - SCREEN_W;
			curtop  = h2 - SCREEN_H;
			break;
		case 270:
			curleft = 0;
			curtop  = h2 - SCREEN_H;
			break;
	}

	if( curleft < 0 )
		curleft = 0;

	if( curtop < 0 )
		curtop = 0;

	return result;
}


//--------------------------------------------------------------------------
//·ҳ
//--------------------------------------------------------------------------
BOOL pdf_page_turn2( int mode )
{
//---------------------------------------------------
	int result = 0;

//---------------------------------------------------
	switch( mode )
	{
		case -1: //Ϸ1ҳ
				pdfapp_onkey( &gapp, 'b' );
				break;
		case 1://·1ҳ
				pdfapp_onkey( &gapp, 'f' );
				break;
		case -10: //Ϸ10ҳ
				pdfapp_onkey( &gapp, 'B' );
				break;
		case 10://·10ҳ
				pdfapp_onkey( &gapp, 'F' );
				break;
		case -100://1ҳ
				pdfapp_onkey( &gapp, 'j' );
				break;
		case 100://1ҳ
				pdfapp_onkey( &gapp, 'k' );
				break;
		default:
				return false;
	}
	reset_pdf_ptr();
	result = pdf_read2( &w_org_r, &h_org_r, &pdfdata, &Bgcolor );
	return result;
}

BOOL pdf_page_turn( dword key )
{
	BOOL result = false;
	if( (key & KEY_L) && (!(key & ~KEY_L)) )//Ϸ1ҳ
	{
		result = pdf_page_turn2( -1 );
	}
	else if( (key & KEY_R) && (!(key & ~KEY_R)) )//·1ҳ
	{
		result = pdf_page_turn2( 1 );
	}
	else if( (key & KEY_A ) && (key & KEY_L) && (!(key & ~(KEY_A | KEY_L))) )//1ҳ
	{
		result = pdf_page_turn2( -100 );
	}
	else if( (key & KEY_A ) && (key & KEY_R) && (!(key & ~(KEY_A | KEY_R))) )//1ҳ
	{
		result = pdf_page_turn2( 100 );
	}

	pdf_thumb();

	return result;
}

//-------------------------------------------------------------------------------
//
//-------------------------------------------------------------------------------
int pdf_handle_input( dword * selidx, KEY_BUF inputkey )
{
//------------ֲ-----------------------
	AJUST_KEY_BUF AjustKey;
	dword key = inputkey.key;
	pixel *VramMainTemp = NULL;
	pixel *Vram = NULL;
	int i,x=0,y=0;
	int w=0,h=0;
	int result = 0;

	if( key == 0 )
		goto _pdf_handle_input_Next;
	if( key == KEY_START )
	{
	}
	else if( key & KEY_B )
	{
		ctrl_waitrelease( key );

		VramMainTemp = (pixel*)memalign( sizeof( pixel ), MSG_W2 * MSG_H2 * sizeof( pixel ) );
		if( VramMainTemp )
		{
			Vram = GetVram( DOWN_SCREEN );
			x = (SCREEN_W - MSG_W2) >> 1;
			y = (SCREEN_H - MSG_H2) >> 1;
			bitBlt2( Vram, SCREEN_W, SCREEN_H, x, y, VramMainTemp, MSG_W2, MSG_H2, 0, 0 );
		}
		result = DrawMessageBox( lang_Notice, CENTER_ALIGN, (const char *)lang_item[LANG_EXITITXT_ID], DOWN_SCREEN, MB_OK | MB_CANCEL, true );

		if( VramMainTemp )
		{
			bitBlt2(VramMainTemp, MSG_W2, MSG_H2, 0, 0,  Vram, SCREEN_W, SCREEN_H, x, y );
			free( VramMainTemp );
		}

		if( result )
		{
			return 1;
		}
		else
		{
			if( VramMainTemp )
			{
				Flush( DOWN_SCREEN );
			}
		}
		VramMainTemp = NULL;
	}
	else if( key == KEY_Y || key == KEY_X )
	{
		goto _ZOOM_OP_PDF;
	}
	else if( key & KEY_SELECT )
	{
		HelpMenuDisplay_Pdf();
	}
	else if( (key & (KEY_LEFT | KEY_RIGHT | KEY_UP | KEY_DOWN)) && (!(key & (~(KEY_LEFT | KEY_RIGHT | KEY_UP | KEY_DOWN)))) )
	{
		pdf_move(key);
	}
	else if( (key & KEY_A ) && ( (key & (KEY_UP | KEY_DOWN)) ) && (!(key & ~(KEY_A | KEY_UP | KEY_DOWN))) )//
	{
_ZOOM_OP_PDF:
		result = pdf_scale( key );
		if( result != 0 )
		{
			report_pdf_error( result );
			return 1;
		}
		else
		{
			pdf_needrp = needp_infobg = true;
		}
	}
	else if( (key & KEY_A ) && ( (key & (KEY_LEFT | KEY_RIGHT)) ) && (!(key & ~(KEY_A | KEY_LEFT | KEY_RIGHT))) )//ת
	{
_ROTATION_OP:
		result = pdf_rotate( key );
		if( result != 0 )
		{
			report_pdf_error( result );
			return 1;
		}
		else
		{
			pdf_needrp = needp_mainbg = true;
		}
	}
	else if( ( (key & (KEY_L | KEY_R)) ) && (!(key & ~( KEY_L | KEY_R))) )//·1ҳ
	{
_PAGE_TURN:
		result = pdf_page_turn( key );
		if( result != 0 )
		{
			report_pdf_error( result );
			return 1;
		}
		else
		{
			curleft = 0;
			curtop  = 0;
			pdf_needrp = needp_mainbg = needp_infobg = true;
		}
	}
	else if( (key & KEY_A ) && ( (key & (KEY_L | KEY_R)) ) && (!(key & ~(KEY_A | KEY_L | KEY_R))) )//1ҳ1ҳ
	{
		result = pdf_page_turn( key );
		if( result != 0 )
		{
			report_pdf_error( result );
			return 1;
		}
		else
		{
			curleft = 0;
			curtop  = 0;
			pdf_needrp = needp_infobg = true;
		}
	}
	else if( key == KEY_TOUCH )
	{
		if( w2 > SCREEN_W || h2 > SCREEN_H )
		{
			AjustKey.Min_x = thumbR.x;
			AjustKey.Max_x = AjustKey.Min_x + thumbR.w - 1;

			AjustKey.Min_y = thumbR.y;
			AjustKey.Max_y = AjustKey.Min_y + thumbR.h - 1;

			result = CheckValidxy( AjustKey, inputkey );
			if( result == 0 )
			{
				AjustKey.Min_x = thumbSR.x;
				AjustKey.Max_x = AjustKey.Min_x + thumbSR.w - 1;

				AjustKey.Min_y = thumbSR.y;
				AjustKey.Max_y = AjustKey.Min_y + thumbSR.h - 1;

				result = CheckValidxy( AjustKey, inputkey );
				if( result == 0 )
				{
					int x_old = inputkey.x;
					int y_old = inputkey.y;
					inputkey = ctrl_waitmove();

					if( inputkey.key == KEY_TOUCH )
					{
						if( inputkey.x < thumbR.x )
							inputkey.x = thumbR.x;
						if( inputkey.x > thumbR.x + thumbR.w - 1 )
							inputkey.x = thumbR.x + thumbR.w - 1;
						if( inputkey.x - x_old > 0 )
						{
							curleft += (inputkey.x - x_old) * w2 / thumbw;;
						}
						else
						{
							curleft -= (x_old - inputkey.x) * w2 / thumbw;;
						}

						if( inputkey.y < thumbR.y )
							inputkey.y = thumbR.y;
						if( inputkey.y > thumbR.y + thumbR.h - 1 )
							inputkey.y = thumbR.y + thumbR.h - 1;

						if( inputkey.y - y_old > 0 )
							curtop += (inputkey.y - y_old) * h2 / thumbh;
						else
							curtop -= (y_old-inputkey.y) * h2 / thumbh;;
					}
					else
						goto _VK_TOUCH_NEXT;
				}
				else
				{
					if( w2 > SCREEN_W )
					{
						if( (inputkey.x - thumbR.x) <= (thumbSR.w >> 1) )
							x = thumbR.x;
						else if( (inputkey.x + (thumbSR.w >> 1)) >= (thumbR.x + thumbR.w - 1) )
							x = thumbR.x + thumbR.w - thumbSR.w;
						else
							x = inputkey.x - (thumbSR.w >> 1);

						curleft = (x - thumbR.x) * w2 / thumbw;
					}
					else
					{
						curleft = 0;
					}

					if( h2 > SCREEN_H )
					{
						if( (thumbR.y + (thumbSR.h >> 1)) >= inputkey.y )
							y = thumbR.y;
						else if( (inputkey.y + (thumbSR.h >> 1)) >= (thumbR.y + thumbR.h - 1) )
							y = thumbR.y + thumbR.h - thumbSR.h;
						else
							y = inputkey.y - (thumbSR.h >> 1);

						curtop = (y - thumbR.y) * h2 / thumbh;
					}
					else
					{
						curtop = 0;
					}
				}
				if( curleft < 0 )
					curleft = 0;
				else if( curleft > w2 - SCREEN_W )
					curleft = w2 - SCREEN_W;

				if( curtop < 0 )
					curtop = 0;
				else if( curtop > h2 - SCREEN_H )
					curtop = h2 - SCREEN_H;

				pdf_needrp = true;
				goto _VK_TOUCH_EXIT;
			}
		}

_VK_TOUCH_NEXT:
		//жǷĸŴ С ʱת ˳ʱת
		for( i = 0; i < OPLOGO_COUNT; i++ )//0/1ֱһһpdfûУԴ2ʼ
		{
			if( i <= 1 )
			{
				x = PrevNext[i].x;
				y = PrevNext[i].y;
				w = OPLOGO_W2;
				h = OPLOGO_H2;
			}
			else if( i == 2 )
			{
				x = OPLOGO_X;
				y = OPLOGO_Y;
				w = OPLOGO_W;
				h = OPLOGO_H;
			}
			else
			{
				x += OPLOGO_W;
			}

			AjustKey.Min_x = x;
			AjustKey.Max_x = AjustKey.Min_x + w;

			AjustKey.Min_y = y;
			AjustKey.Max_y = AjustKey.Min_y + h;

			result = CheckValidxy( AjustKey, inputkey );
			if( result == 0 )
			{
				image_draw_opLogo( BIT( i ), BIT( i ) );
				Flush( DOWN_SCREEN );

				ctrl_waitrelease( key );
				image_draw_opLogo( BIT( i ), 0 );
				switch( i )
				{
					case 0://һҳ
						key = KEY_L;
						goto _PAGE_TURN;

					case 1://һҳ
						key = KEY_R;
						goto _PAGE_TURN;

					case 2:
						key = KEY_X;
						goto _ZOOM_OP_PDF;

					case 3:
						key = KEY_Y;
						goto _ZOOM_OP_PDF;

					case 4:
						key = KEY_A | KEY_LEFT;
						goto _ROTATION_OP;

					case 5:
						key = KEY_A | KEY_RIGHT;
						goto _ROTATION_OP;
				}
			}
		}
_VK_TOUCH_EXIT:;
	}
	else
	{
	}
_pdf_handle_input_Next:
		return 0;
}


int scene_printpdf( int selidx )
{
//------------------ֲ--------------------------
	int x,y;
	dword w = 0,h = 0;
	pixel *Vram = (pixel*)bufferSub;
	char infostr[64];

	int len;
	int result;
	pixel *imgdata = NULL;
	pixel bgc;

//--------------------------------------------------
	if( !Vram )
	{
		return -1;
	}
	memsetword( Vram, Bgcolor, SCREEN_W * SCREEN_H );//ʾɫ

	if( w2 >= SCREEN_W )
	{
		w = SCREEN_W;
		paintleft = 0;
	}
	else
	{
		w = w2;
		paintleft = ( SCREEN_W - w2 ) / 2;
	}

	if( h2 >= SCREEN_H )
	{
		h = SCREEN_H;
		painttop = 0;
	}
	else
	{
		h = h2;
		painttop = ( SCREEN_H - h2 ) / 2;
	}

	for( y = 0; y < h; y++ )
	{
		for( x = 0; x < w; x++ )
		{
			Vram[(painttop*SCREEN_W + paintleft) + (y*SCREEN_W+x)] = pdfdata[(curtop + y)*w2+ (curleft + x)];
		}
	}

//---------------------------------------------------------------------------------------
	Vram = (pixel*)GetVram( DOWN_SCREEN );

	if( needp_mainbg )
	{
		FillRect( CONFIG_THUMB_X, CONFIG_THUMB_Y, CONFIG_THUMBW, CONFIG_THUMBH, Bgcolor, DOWN_SCREEN );//ʾɫ
	}

	if ( needp_infobg )
	{
		needp_infobg = false;
		if( imgTitleBarbuf )
		{
			bitBlt1( imgTitleBarbuf, IMAGE_TITLEBAR_W, IMAGE_TITLEBAR_H, Vram, SCREEN_W, SCREEN_H, 0, 0 );
		}
		else
		{
			result = image_read_sys( CONFIG_IMAGETITLEBAR, fs_file_get_type( CONFIG_IMAGETITLEBAR ), &w, &h, &imgdata, &bgc );
			if( result == 0 )
			{
				imgTitleBarbuf = imgdata;
				bitBlt1( imgdata, w, h, Vram, SCREEN_W, SCREEN_H, 0, 0 );
			}
			else
			{
				FillRect( 0, 0, SCREEN_W, IMAGE_TITLEBAR_H, COLOR_BLACK, DOWN_SCREEN );
			}
		}

		{
			int m,n;
			char strtemp[12];
			m = pdfFilesize >> 10;
			n = ((pdfFilesize & 0x03FF) * 10) >> 10;
			int page_count = pdfapp_getpagecount( &gapp );
			int curpage = pdfapp_getcurpage( &gapp );

			STRCPY_S( infostr, lang_item[LANG_FILESIZE_ID] );//Fsize:xxxx
			SPRINTF_S( strtemp, "%d.%dKB  ", m, n );
			STRCAT_S( infostr, strtemp );

			STRCAT_S( infostr, lang_item[LANG_PDF_PAGE_ID] );//Page:xxxx
			SPRINTF_S( strtemp, "%d / %d  ", curpage, page_count );
			STRCAT_S( infostr, strtemp );

			STRCAT_S( infostr, lang_item[LANG_ZOOM_ID] );
			SPRINTF_S( strtemp, "%d%%", (int) (gapp.zoom * 100) );//Ҫ޸
			STRCAT_S( infostr, strtemp );

			len = strlen(infostr);

//			w = text_get_string_width_sys2( (const byte*)infostr, len, 0 );
			w = CB_text_get_string_width_sys( (const byte *)infostr, 0, CONFIG_FONTW_SYS, GetlanguageCodingType() );
//			DrawTextLinen_sys( (SCREEN_W - w)>>1 , IMAGE_INFO_Y, 0, (const byte*)infostr, len, IMAGE_INFO_FCOLOR, DOWN_SCREEN );
			CB_putnstringhorz_sys( (SCREEN_W - w)>>1 , IMAGE_INFO_Y, 0, (const byte*)infostr, len, IMAGE_INFO_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
		}
	}

	needp_mainbg = false;

	w = thumbw;
	paintleft = ( SCREEN_W - w ) / 2;

	h = thumbh;
	painttop = CONFIG_THUMB_Y + ( CONFIG_THUMBH - h ) / 2;

	thumbR.x = paintleft - 1;//ͼβ
	thumbR.y = painttop - 1;
	thumbR.w = w;
	thumbR.h = h;

	int x1,y1,x2,y2, w1, h1;
	pixel R,G,B,R1,G1,B1,R2,G2,B2;
	pixel bgcolor;

	if( w2 <= SCREEN_W )
	{
		x1 = 0;
		w1 = thumbw;
	}
	else
	{
		x1 = curleft * thumbw / w2;
		w1 = SCREEN_W * thumbw / w2;
	}

	if( h2 <= SCREEN_H )
	{
		y1 = 0;
		h1 = thumbh;
	}
	else
	{
		y1 = curtop * thumbh / h2;
		h1 = SCREEN_H * thumbh / h2;
	}

	x2 = x1 + w1 - 1;
	y2 = y1 + h1 - 1;

	thumbSR.x = paintleft - 1 + x1;//ͼѡβ
	thumbSR.y = painttop - 1 + y1;
	thumbSR.w = w1;
	thumbSR.h = h1;

	R2 = RGB_R( COLOR_BLACK );
	G2 = RGB_G( COLOR_BLACK );
	B2 = RGB_B( COLOR_BLACK );

#define		T		( 1000 ) //1000
#define		T1		( 500 ) //1000 //ɫռ
#define		T2		( T - T1 ) //1000 //ǰɫռ
#define		LINE_W	3 //ѡ߿


	for( y = 0; y < h; y++ )//thumbh
	{
		for( x = 0; x < w; x++ )//thumbw
		{
			if( x >= x1 && x <= x2 && y >= y1 && y <= y2 )
			{
				Vram[(painttop*SCREEN_W + paintleft) + (y*SCREEN_W+x)] = thumbimg[y*w+ x];
			}
			else
			{
				bgcolor = thumbimg[y*w+ x];
				R1 = RGB_R( bgcolor );
				G1 = RGB_G( bgcolor );
				B1 = RGB_B( bgcolor );

				R = (R1 * T1 + R2 * T2) / T;
				G = (G1 * T1 + G2 * T2) / T;
				B = (B1 * T1 + B2 * T2) / T;
				Vram[(painttop*SCREEN_W + paintleft) + (y*SCREEN_W+x)] = RGB15( R,G,B );
			}
		}
	}

	Flush( DOWN_SCREEN );
	Flush( UP_SCREEN );
	return 0;
}

int pdf_open_archive(const char *filename, const char *archname, dword * pWidth, dword * pHeight,
											pixel ** ppPdfData, pixel * pBgColor, int where)
{
	int result = -1;
	switch (where)
	{
		case scene_in_zip:
			result = -1;
			break;
		case scene_in_chm:
			result = -1;
			break;
		case scene_in_rar:
			result = -1;
			break;
		default:
			break;
	}
	return result;
}

int pdf_read2( dword * pWidth, dword * pHeight, pixel **ppPdfData, pixel * pBgColor )
{
//------------------------------------------------------
	int w = 0;//pdfҳʵʿ͸
	int h = 0;
	int srcstride = 0;
	int dststride = 0;

	unsigned char *pdf_data_src = NULL;
	pixel *pdf_data_dst = NULL;

//------------------------------------------------------
	w = gapp.image->w;//pdfһҳʵʿ͸
	h = gapp.image->h;

//-------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------
	pdf_data_src = (unsigned char *)gapp.image->samples;
	pdf_data_dst = (pixel*)malloc_pdf( w * h * gapp.image->n ); //pdfҳСڴ
	if( !pdf_data_dst )
	{
		return -1;
	}
	srcstride	= w<<2;
	dststride	= w<<2;

	ximage_convert_bgra8888( pdf_data_src, srcstride, pdf_data_dst, dststride, w, h );

	*pWidth = w;
	*pHeight = h;

	*pBgColor = COLOR_BLACK;//ɫ

	*ppPdfData = pdf_data_dst;

	w2 = w;//ʵʾĿ, δϢ
	h2 = h;

	return 0;
}

int pdf_read(const char *filename, dword * pWidth, dword * pHeight, pixel **ppPdfData, pixel * pBgColor)
{
//---------------ֲ-----------------------------
	double zoom = 1.0;
	int  pageno = 1;

	int x0 = 0;
	int y0 = 0;
	int x1 = 0;
	int y1 = 0;

//------------ȡpdf	----------------------------------
	pdfapp_init(&gapp);

	gapp.scrw = SCREEN_W;
	gapp.scrh = SCREEN_H;
	gapp.zoom = zoom;
	gapp.pageno = pageno;

	pdfapp_open(&gapp, filename);

	x0 = gapp.panx;
	y0 = gapp.pany;
	x1 = gapp.panx + gapp.image->w;
	y1 = gapp.pany + gapp.image->h;

	return pdf_read2( pWidth, pHeight, ppPdfData, pBgColor );
}

int pdf_open_normal( const char *filename, dword * pWidth, dword * pHeight, pixel **ppPdfData, pixel * pBgColor )
{
	int result = -1;

	if( filename == NULL || pWidth == NULL || pHeight == NULL || pBgColor == NULL || ppPdfData == NULL )
		return -1;

	result = pdf_read(filename, pWidth, pHeight, ppPdfData, pBgColor);
	return result;
}


int open_pdf(dword selidx)
{
	int result;

	if (where == scene_in_dir)
	{
		result = pdf_open_normal( filename, &w_org_r, &h_org_r, &pdfdata, &Bgcolor );
		return result;
	}
	else
	{
		result = pdf_open_archive( filename, config.Upath,//filename: ȫֱ
						   &w_org_r, &h_org_r, &pdfdata, &Bgcolor, where );
	}
	return result;
}

int scene_reloadpdf(dword selidx)
{
	if( pdf_close_flag == false )
	{
		pdfapp_close( &gapp );
		mem_con_free_all();
		pdf_close_flag = true;
	}
	reset_pdf_ptr();
	if (where == scene_in_zip || where == scene_in_chm || where == scene_in_rar)
		STRCPY_S(filename, filelist[selidx].Uname);
	else
	{
		STRCPY_S(filename, config.Upath);
		STRCAT_S(filename, filelist[selidx].Uname);
	}
	int result = open_pdf( selidx );
	pdf_close_flag = false;

	if (result != 0)
	{
		report_pdf_error(result);
		return -1;
	}
	STRCPY_S(config.lastfile, filelist[selidx].Uname);

	curtop = 0;//2009-8-29 12:00:13
	curleft = 0;//2009-8-29 12:00:13

//-----------------------------ͼ-------------------------------
	pdf_thumb();

	return 0;
}

void pdf_thumb( void )
{
	if( w_org_r > CONFIG_THUMBW && h_org_r > CONFIG_THUMBH )
	{
		if( CONFIG_THUMBW * h_org_r < CONFIG_THUMBH * w_org_r )
		{
			thumbw = CONFIG_THUMBW;//ͼ
			thumbh = h_org_r * CONFIG_THUMBW / w_org_r;//ͼ
		}
		else
		{
			thumbh = CONFIG_THUMBH;
			thumbw = w_org_r * CONFIG_THUMBH / h_org_r;
		}
	}
	else if( w_org_r > CONFIG_THUMBW )
	{
		thumbw = CONFIG_THUMBW;//ͼ
		thumbh = h_org_r * CONFIG_THUMBW / w_org_r;//ͼ
	}
	else if( h_org_r > CONFIG_THUMBH )
	{
		thumbh = CONFIG_THUMBH;
		thumbw = w_org_r * CONFIG_THUMBH / h_org_r;
	}
	else
	{
		thumbw = w_org_r;
		thumbh = h_org_r;
	}

	image_zoom_bilinear( pdfdata, w_org_r, h_org_r, thumbimg, thumbw, thumbh );
}


int pdf_main( dword selidx )
{
//---------ֲ-----------------
	int ret = -1;

//---------ȫֱʼ-----------------
	pdf_needrf = true;//ǷҪȡļ
	pdf_needrp = true;//ǷҪ´ӡļ

	int i;
	int result;
	KEY_BUF inputkey;
	dword w, h;
	pixel *imgdata = NULL;
	pixel bgc;
	result = image_read_sys( CONFIG_PDFLOADING, fs_file_get_type( CONFIG_PDFLOADING ), &w, &h, &imgdata, &bgc );
	if( result == 0 )
	{
		LoadVram( imgdata, DOWN_SCREEN );
		Flush( DOWN_SCREEN );
	}

	if( imgdata )
	{
		free((void*)imgdata);
		imgdata = NULL;
	}

//------------BEGIN------------------------
	mem_con_init_all();
//-------------------------------------------------------------

	needp_infobg = true;
	needp_mainbg = true;
	FillVram( COLOR_BLACK, DOWN_SCREEN );//ʾɫ
	image_draw_opLogo( 0x03F, 0x00 );

	if( bookfontindex_cur != 0 )
	{
		scene_load_book_font( 0 );//ָ
	}
	font_in_book = true;

	while( 1 )
	{
		if ( pdf_needrf )
		{
			pdfFilesize = (U32)filelist[selidx].data3;
			dword ret = scene_reloadpdf(selidx);
			if (ret == -1)
			{
				break;
			}
			pdf_needrf = false;
		}

		if (pdf_needrp)
		{
			scene_printpdf(selidx);
			pdf_needrp = false;
		}
		while( !(Proc_GetInput( &inputkey, CONFIG_KEY_REPEAT_TIME_N )) )
		{
		}

		ret = pdf_handle_input( &selidx, inputkey );
		if( ret == 1 )
		{
			break;
		}
	}//while( 1 )
	if( pdfdata != NULL )
	{
		free((void *) pdfdata);
		pdfdata = NULL;
	}
	pdfapp_close(&gapp);
	mem_con_free_all();
	pdf_close_flag = true;

	for( i = 0; i < OPLOGO_COUNT; i ++ )
	{
		if( neepr_oplogo & BIT( i ) )
		{
			free( opLogoBuf[i] );
			opLogoBuf[i] = NULL;
		}

		if( neepr_oplogo2 & BIT( i ) )
		{
			free( opLogoBuf2[i] );
			opLogoBuf2[i] = NULL;
		}
	}

	neepr_oplogo = 0;
	neepr_oplogo2 = 0;

	if( imgTitleBarbuf )
	{
		free( imgTitleBarbuf );
		imgTitleBarbuf = NULL;
	}

	font_in_book = false;

	return selidx;
}
