#include "fitz-base.h"

#include <MemMgr.h>
#include <debugoff.h>

#if !MUPDF_X86
//#include <DrvMemMgr.h>
#endif

#undef  MEM_RECORD
#define MEM_RECORD    1 //Ƿ¼ڴƣͷţ

extern void *malloc_pdf( unsigned int nbytes );
extern void *zmalloc_pdf( unsigned int nbytes );
extern void *calloc_pdf( unsigned nelem, unsigned elsize );
extern void *realloc_pdf( void *address,unsigned int nbytes);
extern void free_pdf( void *buffer );

fz_memorycontext *fz_currentmemorycontext2();
#define fz_currentmemorycontext() fz_currentmemorycontext2()


/* Make this thread local storage if you wish.  */

static void *stdmalloc(fz_memorycontext *mem, int n)
{
	void *p = (void*)malloc_pdf( n );
	if (!p)
			fz_warn("cannot malloc %d bytes", n);

#if MEM_RECORD
	if( mem_effective == 1 )
	{
		if( p )
			MEMM( n, p, malloc_pdf, PDF_MEM_ID );
	}
#endif

	return p;
}

static void *stdrealloc(fz_memorycontext *mem, void *p, int n)
{
	void *np = realloc_pdf(p, n);

#if MEM_RECORD
	if( mem_effective == 1 )
	{
		if( p != np )
		{
			MEMR( n, p, np, malloc_pdf, PDF_MEM_ID );
		}
	}
#endif

	return np;
}

static void stdfree(fz_memorycontext *mem, void *p)
{
#if MEM_RECORD
	if( mem_effective == 1 )
	{
		MEMF( p, free_pdf, PDF_MEM_ID );
	}
#endif

	free_pdf(p);
}

static fz_memorycontext defmem = { stdmalloc, stdrealloc, stdfree };
static fz_memorycontext *curmem = &defmem;

fz_error fz_koutofmem = {
	{"out of memory"},
	{"<internal>"},
	{"<internal>"},
	0,
	nil
};

//static
fz_memorycontext *
fz_currentmemorycontext2()//ⲿеô˺,filt_flate.c
{
	return curmem;
}

static //2009-10-14 11:13:12 by LHM
void
fz_setmemorycontext(fz_memorycontext *mem)
{
	curmem = mem;
}


void *
fz_malloc(int n)
{
    fz_memorycontext *mem = fz_currentmemorycontext();
    void *p = mem->malloc2( mem, n );
    if (!p)
			fz_warn("cannot malloc %d bytes", n);
    return p;
}

void *
fz_realloc(void *p, int n)
{
    fz_memorycontext *mem = fz_currentmemorycontext();
    void *np = mem->realloc(mem, p, n);
    if (np == nil)
			fz_warn("cannot realloc %d bytes", n);
    return np;
}

void
fz_free(void *p)
{
	if( p == NULL )
		return;
	fz_memorycontext *mem = fz_currentmemorycontext();
	mem->free(mem, p);
  	p = 0;
}

char *
fz_strdup(char *s)
{
	int len = strlen(s);
	char *ns = fz_malloc(len + 1);
	if (ns)
		strcpy(ns, s);
	return ns;
}
