
#SOURCES	+=  $(wildcard *.c)


BASE_SRC = \
	base_memory.c \
	base_error.c \
	base_hash.c \
	base_matrix.c \
	base_rect.c \
	base_rune.c \
	base_cpudep.c \

BASE_SRC += \
	util_strlcpy.c \
#	util_strlcat.c \


STREAM_SRC = \
	crypt_aes.c \
	crypt_arc4.c \
	crypt_crc32.c \
	crypt_md5.c \
	filt_a85d.c \
	filt_a85e.c \
	filt_aes.c \
	filt_ahxd.c \
	filt_ahxe.c \
	filt_arc4.c \
	filt_faxd.c \
	filt_faxdtab.c \
	filt_faxe.c \
	filt_faxetab.c \
	filt_flate.c \
	filt_lzwd.c \
	filt_lzwe.c \
	filt_null.c \
	filt_pipeline.c \
	filt_predict.c \
	filt_rld.c \
	filt_rle.c \
	obj_array.c \
	obj_dict.c \
	obj_parse.c \
	obj_print.c \
	obj_simple.c \
	stm_buffer.c \
	stm_filter.c \
	stm_misc.c \
	stm_open.c \
	stm_read.c \
	stm_write.c \
	filt_dctd.c \
	filt_dcte.c \

STREAM_SRC += filt_jbig2d.c

RASTER_SRC = \
	archx86.c \
	blendmodes.c \
	imagescale.c \
	pathfill.c \
	pixmap.c \
	glyphcache.c \
	imageunpack.c \
	pathscan.c \
	porterduff.c \
	imagedraw.c \
	meshdraw.c \
	pathstroke.c \
	render.c \

WORLD_SRC = \
	node_misc1.c \
	node_misc2.c \
	node_optimize.c \
	node_path.c \
	node_text.c \
	node_toxml.c \
	node_tree.c \
	res_colorspace.c \
	res_font.c \
	res_image.c \
	res_shade.c \

MUPDF_SRC = \
	pdf_annot.c \
	pdf_build.c \
	pdf_cmap.c \
	pdf_colorspace1.c \
	pdf_colorspace2.c \
	pdf_crypt.c \
	pdf_debug.c \
	pdf_doctor.c \
	pdf_font.c \
	pdf_fontagl.c \
	pdf_fontenc.c \
	pdf_function.c \
	pdf_image.c \
	pdf_interpret.c \
	pdf_lex.c \
	pdf_nametree.c \
	pdf_open.c \
	pdf_outline.c \
	pdf_page.c \
	pdf_pagetree.c \
	pdf_parse.c \
	pdf_pattern.c \
	pdf_repair.c \
	pdf_resources.c \
	pdf_save.c \
	pdf_shade.c \
	pdf_shade1.c \
	pdf_shade4.c \
	pdf_store.c \
	pdf_stream.c \
	pdf_type3.c \
	pdf_unicode.c \
	pdf_xobject.c \
	pdf_xref.c \
	pdf_fontfile.c \


FONTS_SRC = \
	NimbusMonL-Regu.cff.c \
	NimbusMonL-Bold.cff.c \
	NimbusMonL-ReguObli.cff.c \
	NimbusMonL-BoldObli.cff.c \
	NimbusSanL-Regu.cff.c \
	NimbusSanL-Bold.cff.c \
	NimbusSanL-ReguItal.cff.c \
	NimbusSanL-BoldItal.cff.c \
	NimbusRomNo9L-Regu.cff.c \
	NimbusRomNo9L-Medi.cff.c \
	NimbusRomNo9L-ReguItal.cff.c \
	NimbusRomNo9L-MediItal.cff.c \
	StandardSymL.cff.c \
	Dingbats.cff.c \
	URWChanceryL-MediItal.cff.c \


FONTCONFIG_SRC = \

#################################
# Ӧó
#################################
APPS_SRC = \
	pdfapp.c

ifeq ($(MUPDF_X86),1)
APPS_SRC +=  \
	x11pdf.c \
	ximage.c
else
APPS_SRC += pdf_main.c
endif


PDF_SRC = \
	${BASE_SRC} \
	${STREAM_SRC} \
	${RASTER_SRC} \
	${WORLD_SRC} \
	${MUPDF_SRC} \
	$(FONTS_SRC) \
	$(FONTCONFIG_SRC) \
	$(APPS_SRC)

SOURCES += $(PDF_SRC)

#PDF_OBJS := $(patsubst %c, %o, $(PDF_SRC))
PDF_OBJS := $(PDF_SRC:%.c=%.o)

CFLAGS	+= -I$(FITZ_DIR)
VPATH   +=  $(FITZ_DIR)

#CFLAGS	+= -I$(FITZ_DIR)/apps
#VPATH   +=  $(FITZ_DIR)/apps

CFLAGS	+= -I$(SUMATRAPDF_DIR)/fitz/apps
VPATH   +=  $(SUMATRAPDF_DIR)/fitz/apps

CFLAGS	+= -I$(FITZ_DIR)/base
VPATH   +=  $(FITZ_DIR)/base

CFLAGS	+= -I$(FITZ_DIR)/stream
VPATH   +=  $(FITZ_DIR)/stream

CFLAGS	+= -I$(FITZ_DIR)/mupdf
VPATH   +=  $(FITZ_DIR)/mupdf

CFLAGS	+= -I$(FITZ_DIR)/world
VPATH   +=  $(FITZ_DIR)/world

CFLAGS	+= -I$(FITZ_DIR)/raster
VPATH   +=  $(FITZ_DIR)/raster

CFLAGS	+= -I$(FITZ_DIR)/fonts
VPATH   +=  $(FITZ_DIR)/fonts


CFLAGS	+= -I$(FITZ_DIR)/include
VPATH   +=  $(FITZ_DIR)/include

CFLAGS	+= -I$(FITZ_DIR)/apps/common
VPATH   +=  $(FITZ_DIR)/apps/common

CFLAGS	+= -I$(FITZ_DIR)/apps/unix
VPATH   +=  $(FITZ_DIR)/apps/unix

CFLAGS	+= -I$(FITZ_DIR)/mem
VPATH   +=  $(FITZ_DIR)/mem