/* vim:set ts=4 sw=4 cindent ignorecase enc=gbk: */

#ifndef _TEXT_H_
#define _TEXT_H_

#include "common/datatype.h"
#include "fs.h"
#include <Macro.h>

extern byte bytetable[256];
extern CodeType cur_code_type;

typedef struct
{
	char *start;//һеʼַ
	dword count;//һЧռõֽ
} t_textrow, *p_textrow;

typedef struct
{
	char filename[PATH_MAX2];//ıļ
	dword crow;//ǰк(ȷʾĵڣ)
	dword size;//ı
	char *buf;//ıָ루ıһԶȡ洢ϣ
	int ucs;
	dword row_count;//ı
	p_textrow rows[1024];//rows:൱ָָָ룬1024rowsС飬ÿһС1024ָ룬ÿָָһ,ԿԱ1024*1024еı
} t_text, *p_text;

extern BOOL text_format(p_text txt, dword rowpixels, dword wordspace,
						BOOL ttf_mode);
extern p_text text_open(const char *filename, t_fs_filetype ft, dword rowpixels,
						dword wordspace, t_conf_encode encode, BOOL reorder);
extern p_text text_open_binary(const char *filename, BOOL vert);
extern p_text text_open_in_raw(const char *filename, const unsigned char *data,
							   size_t size, t_fs_filetype ft, dword rowpixels,
							   dword wordspace, t_conf_encode encode,
							   BOOL reorder);
extern p_text text_open_in_zip(const char *zipfile, const char *filename,
							   t_fs_filetype ft, dword rowpixels,
							   dword wordspace, t_conf_encode encode,
							   BOOL reorder);
extern p_text text_open_in_gz(const char *gzfile, const char *filename,
							  t_fs_filetype ft, dword rowpixels,
							  dword wordspace, t_conf_encode encode,
							  BOOL reorder);
extern p_text text_open_in_rar(const char *rarfile, const char *filename,
							   t_fs_filetype ft, dword rowpixels,
							   dword wordspace, t_conf_encode encode,
							   BOOL reorder);
extern p_text text_open_in_chm(const char *chmfile, const char *filename,
							   t_fs_filetype ft, dword rowpixels,
							   dword wordspace, t_conf_encode encode,
							   BOOL reorder);
extern p_text text_open_binary_in_rar(const char *rarfile, const char *filename,
									  t_fs_filetype ft, dword rowpixels,
									  dword wordspace, t_conf_encode encode,
									  BOOL reorder, BOOL vert);
extern p_text text_open_binary_in_zip(const char *zipfile, const char *filename,
									  t_fs_filetype ft, dword rowpixels,
									  dword wordspace, t_conf_encode encode,
									  BOOL reorder, BOOL vert);
extern void text_close(p_text fstext);

extern p_text text_open_archive(const char *filename,
								const char *archname,
								t_fs_filetype filetype,
								dword rowpixels,
								dword wordspace,
								t_conf_encode encode,
								BOOL reorder, int where, int vertread);

int text_get_string_width_sys( const byte * pos, size_t size, dword wordspace );
int text_get_string_width(const byte *pos, const byte *posend, dword maxpixel, dword wordspace, dword * count, dword fontsize );
int text_read_sys( const char *filename, char ** ppTxtData, int *len );

#endif
