#include "memory_tiff.h"
#include <MemMgr.h>
#include <DrvMemMgr.h>
  
#include <debugoff.h>
        
extern void *tiff_smalloc2( unsigned int n )
{
	void *p = malloc_pdf( n );
#if MEM_RECORD	
	if( mem_effective == 1 )
	{
		if( p )
				MEMM( n, p, malloc_pdf, TIFF_MEM_ID );
	}
#endif
	return p;
}

extern void *tiff_srealloc2( void *p,unsigned int n )
{
	void *np = realloc_pdf(p, n);

#if MEM_RECORD	
	if( mem_effective == 1 )
	{
//		if( p != np )
		{
			MEMR( n, p, np, malloc_pdf, TIFF_MEM_ID );
		}
	}
#endif   
	
	return np;
}

extern void *tiff_scalloc2( unsigned int nelem,unsigned int elsize )
{
	void *p = calloc_pdf( nelem, elsize );

#if MEM_RECORD	
	if( mem_effective == 1 )
	{
	if( p )
		{
			MEMM( nelem * elsize, p, malloc_pdf, TIFF_MEM_ID );
		}
	}
#endif
	
	return p;
}


extern void tiff_sfree2( void *p )
{
#if MEM_RECORD
	if( mem_effective == 1 )
	{
		MEMF( p, free_pdf, TIFF_MEM_ID );
	}
#endif
	
	free_pdf(p);
}
