#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include "config_ebook.h"
#include "utils.h"
#include "strsafe.h"

#include <DrvMemMgr.h>
#include <debugoff.h>

extern dword utils_dword2string(dword dw, char *dest, dword width)
{
	dest[width] = 0;
	if (dw == 0) {
		dest[--width] = '0';
		return width;
	}
	while (dw > 0 && width > 0) {
		dest[--width] = '0' + (dw % 10);
		dw /= 10;
	}
	return width;
}

extern BOOL utils_string2dword(const char *src, dword * dw)
{
	*dw = 0;
	while (*src >= '0' && *src <= '9') {
		*dw = *dw * 10 + (*src - '0');
		src++;
	}
	return (*src == 0);
}

extern BOOL utils_string2double(const char *src, double *db)
{
	*db = 0.0;
	BOOL doted = false;
	double p = 0.1;

	while ((*src >= '0' && *src <= '9') || *src == '.') {
		if (*src == '.') {
			if (doted)
				return false;
			else
				doted = true;
		} else {
			if (doted) {
				*db = *db + p * (*src - '0');
				p = p / 10;
			} else
				*db = *db * 10 + (*src - '0');
		}
		src++;
	}
	return (*src == 0);
}

extern const char *utils_fileext(const char *filename)
{
	dword len = strlen(filename);
	const char *p = filename + len;

	while (p > filename && *p != '.' && *p != CONFIG_DIR_SEPERATOR)
		p--;
	if (*p == '.')
		return p + 1;
	else
		return NULL;
}

void *realloc_free_when_fail(void *ptr, size_t size)
{	
	void *p = realloc(ptr, size);
	if (p == NULL ) 
	{
		if (ptr)
			free(ptr);
		ptr = NULL;
	}
	return p;
}
