/* vim:set ts=4 sw=4 cindent ignorecase enc=gbk: */

#include "config.h"
#include <stdlib.h>
#include <string.h>
#include "common/utils.h"
#include "display.h"
#include "ctrl.h"
#include "win.h"
#include "conf.h"
#include "fat_ebook.h"
#include "scene.h"

#include <fs.h>
#include "bg.h"

#include <Macro.h>
#include <ds2io2.h>
#include <Macro.h>
#include <mystring.h>
#include <MainMenuSettings.h>
#include <gdi.h>
#include <key.h>
#include <ds2_timer.h>
#include <DrvMemMgr.h>

#include <debugoff.h>

BOOL swap_infowin = false;

static bool mscrf;//޸ı־
static BOOL mbodyf;//(ı)޸ı־(Ҳı)
static s32 mbodyy;//(ı)޸y(Ҳı)
static s32 mbodyx;//(ı)޸x(Ҳı)
static BOOL mf;

static bool mb;
static s32 msx,msy;
static s32 mx,my;
static s32 movespeed;//ΪֵΪֵ
static s32 mvsynccnt;

static s32 movey;//ΪֵΪֵmovespeed෴
static s32 automovey;//movespeedԶƶ
static bool AlignLineFlag = true;
static int ts_count = 0;
static bool movescreenflag;//ƶ־ҪԶƶسһĸ߶(FL_LINE_H*MAX_ITEM_LINE),˱־1Ϊ0
static bool movelineflag;//ƶб־ҪԶƶسһеĸ߶(FL_LINE_H),˱־1Ϊ0
static int stepidx;
static s32 step;

static dword Index, lastsel, topindex, botindex, countindex;
static BOOL needrp_subbg = true;
static BOOL needrp = true;

#define		VerticalFadeStepCount		21
static const U32 VerticalFadeStep[VerticalFadeStepCount]={2,4,5,6,7,8,9,9,9,9,9,9,9,9,8,8,6,5,4,3,2,};

#define			USE_DYNAMIC_VRAMBUFFER				0
#define			BG_COLOR_USE						0

#if !USE_DYNAMIC_VRAMBUFFER
pixel FlVram[FL_LINE_W*FL_LINE_H*MAX_ITEM_LINE * 3];
#endif

static p_win_menuitem WinItem = NULL;
dword *TxtidxTab = NULL;
dword *PicidxTab = NULL;

//-----------------------------------ȫֱ---------------------------------------
pixel Ret_UnselectLine_Bufffer[SCREEN_W * FL_LINE_H];//̬ͼ񻺴
pixel Ret_SelectLine_Bufffer[SCREEN_W * FL_LINE_H];//̬ͼ񻺴
pixel *Ret_UnselectLine_Buf = (pixel *)Ret_UnselectLine_Bufffer;
pixel *Ret_SelectLine_Buf = (pixel *)Ret_SelectLine_Bufffer;

pixel FLSlideBuf[FL_SLIDE_W*FL_SLIDE_H];//

//-----------------------ȫֱ-------------------------------
extern t_conf config;
extern pixel * bufferMain;
extern pixel * bufferSub;
extern pixel FLTimeResumeBuf[FL_TIME_W*FL_TIME_H];

//-----------------------ȫֺ-------------------------------
static int Proc_TouchPad( KEY_BUF inputkey );

//---------------------------------------------------------------
//---------------------ʼ----------------------------------
//---------------------------------------------------------------
extern t_win_menu_op win_menu_defcb( dword key, p_win_menuitem item,
									dword * count, dword max_height,
									dword * topindex, dword * index)
{
	switch (key)
	{
		case KEY_UP:
			if (*index == 0)
				*index = *count - 1;
			else
				(*index)--;
			return win_menu_op_redraw;
		case KEY_DOWN:
			if (*index == *count - 1)
				*index = 0;
			else
				(*index)++;
			return win_menu_op_redraw;
		case KEY_LEFT:
			if (*index < max_height - 1)
				*index = 0;
			else
				*index -= max_height - 1;
			return win_menu_op_redraw;
		case KEY_RIGHT:
			if (*index + (max_height - 1) >= *count)
				*index = *count - 1;
			else
				*index += max_height - 1;
			return win_menu_op_redraw;
#if 0
		case KEY_L:
			*index = 0;
			return win_menu_op_redraw;
		case KEY_R:
			*index = *count - 1;
			return win_menu_op_redraw;
#endif
		case KEY_A:
			ctrl_waitrelease( key );
			return win_menu_op_ok;
		case KEY_B:
			ctrl_waitrelease( key );
			return win_menu_op_cancel;
	}
	return win_menu_op_continue;
}

extern t_win_menu_op win_menu_defcb2( KEY_BUF inputkey, p_win_menuitem item,
									dword * count, dword max_height,
									dword * topindex, dword * index)
{
	return win_menu_defcb( 	inputkey.key, item, count, max_height, topindex, index );
}

void ShowDateTime(  RTC *rtc, int x0, int y0, pixel color, BOOL Isbookfontsize, SCREEN_ID engine, BOOL IsShowSecond, int ShowYeadMode, char Year_Separator )//ShowYeadMode 0: ʾ1ֻʾλ2겻ʾ
{
	int x,y,i,n;
	char str[32];
	U8 Year, Month, Day, Hours, Minutes, Seconds;
	int fontw,fonth;
#if USE_UNICODE_FONTLIB
	byte ucs2[8];
#endif

	Year = rtc->year;
	Month = rtc->month;
	Day = rtc->day;
	Hours = rtc->hours;
	Minutes = rtc->minutes;
	Seconds = rtc->seconds;

#define		SHOW_ZERO			1

	font_in_book = Isbookfontsize;

	if( font_in_book == false )
	{
		fontw = CONFIG_FONTW_SYS;
		fonth = CONFIG_FONTH_SYS;
	}
	else
	{
		fontw = DISP_BOOK_FONTSIZE;
		fonth = DISP_BOOK_FONTSIZE;
	}

	i = 0;

	if( ShowYeadMode == 0 )
	{
		dwordToString( (char *)(str+i), 5, 2000 + Year );
		i += 4;
		str[i++] = Year_Separator;
	}
	else if( ShowYeadMode == 1 )
	{
		if( Year < 10 )
		{
			str[i++] = '0';
			dwordToString( (char *)(str+i), 2, Year );
			i++;
		}
		else
		{
			dwordToString( (char *)(str+i), 3, Year );
			i += 2;
		}
		str[i++] = Year_Separator;
	}


	if( Month < 10 )
	{
#if SHOW_ZERO
		str[i++] = '0';
#endif
		dwordToString( (char *)(str+i), 2, Month );
		i++;
	}
	else
	{
		dwordToString( (char *)( str + i ), 3, Month );
		i += 2;
	}

	str[i++] = Year_Separator;
	if( Day < 10 )
	{
#if SHOW_ZERO
		str[i++] = '0';
#endif
		dwordToString( (char *)(str+i), 2, Day );
		i++;
	}
	else
	{
		dwordToString( (char *)( str + i ), 3, Day );
		i += 2;
	}
	str[i++] = ' ';
	str[i++] = ' ';
//	str[i++] = ' ';

//------------------ʱ-------------------------------
{
//	font_in_book = Isbookfontsize;

#if 0
	if( Hours >= 12 )
		Hours = 12 + Hours - 52;
#endif

	if( Hours < 10 )
	{
#if SHOW_ZERO
		str[i++] = '0';
#endif
		dwordToString( (char *)(str+i), 2, Hours );
		i++;
	}
	else
	{
		dwordToString( (char *)(str+i), 3, Hours );
		i += 2;
	}

	str[i++] = ':';
	if( Minutes < 10 )
	{
#if SHOW_ZERO
		str[i++] = '0';
#endif
		dwordToString( (char *)(str+i), 2, Minutes );
		i++;
	}
	else
	{
		dwordToString( (char *)( str + i ), 3, Minutes );
		i += 2;
	}

	if( IsShowSecond )
	{
		str[i++] = ':';
		if( Seconds < 10 )
		{
#if SHOW_ZERO
			str[i++] = '0';
#endif
			dwordToString( (char *)(str+i), 2, Seconds );
			i++;
		}
		else
		{
			dwordToString( (char *)( str + i ), 3, Seconds );
			i += 2;
		}
	}
	str[i] = '\0';
	n = i;

	//ָʱ䱳
//	bitBlt1( TimeResumeBuf, TIME_RECT_BG_W, TIME_RECT_BG_H, Vram, SCREEN_W, SCREEN_H, MENU_SETTINGS_TIME_X, MENU_SETTINGS_TIME_Y );
	if( x0 < 0 )
	{
		int w = 0;
		for( i = 0; i < n; i++ )
		{
			if( *(str+i) == ':' )
			{
				w += 2;
			}
			w += (DISP_FONTSIZE >> 1) + TIME_NUM_DISTANCE;
		}

		x = NOTICE_HELP_LOGO_X + NOTICE_HELP_LOGO_W;
		if( notice_exit_font_x > 0 )
		{
			x += ( notice_exit_font_x - x - w ) >> 1;
		}
		else
		{
			x = ( NOTICE_EXIT_LOGO_X - 22 - x - w ) >> 1;
		}
		x0 = x;
	}

	x = x0;
	y = y0;
	for( i = 0; i < n; i++ )
	{
		if( *(str+i) == ':' )
		{
			x += 2;
			y = y0 - 1;
		}
		else
			y = y0;
//		GDIDrawChar( x, y, (const byte *)(str+i), color, engine );
#if USE_UNICODE_FONTLIB
		memset( ucs2, 0x00, 8 );
		utf8decode( str+i, ucs2 );
		CB_disp_putcharhorz( x, y,  fontw, fonth, (const byte *)ucs2, color, engine );
#else
		CB_disp_putcharhorz( x, y,  fontw, fonth, (const byte *)(str+i), color, engine );
#endif

		x += (DISP_FONTSIZE >> 1) + TIME_NUM_DISTANCE;
	}

	font_in_book = false;
}
}


void DrawSlide( dword index, dword count, SCREEN_ID engine )//
{
	int y0;
	pixel *Vram = GetVram( engine );
	pixel *src = NULL;

	int i,j;
	for( j = 0; j < ( FL_SLIDE_MAX_Y - FL_SLIDE_Y + FL_SLIDE_H ); j++ )
	{
		src = Vram + (FL_SLIDE_Y+j) * SCREEN_W + FL_SLIDE_X;
		for( i = 0; i < FL_SLIDE_W; i++ )
		{
			*src++ = 0x9083;
		}
	}

	if( count >= 2 )
	{
		y0 = FL_SLIDE_Y + (FL_SLIDE_MAX_Y - FL_SLIDE_Y) * index / (count-1);
	}
	else
	{
		y0 = FL_SLIDE_Y;
	}
	bitBlt1( SlideLOGO, FL_SLIDE_W, FL_SLIDE_H, Vram, SCREEN_W, SCREEN_H, FL_SLIDE_X, y0 );
}


int ProcessItemNull( int CategoryFlag )
{
	int i;
	int y0;
	int result;
	AJUST_KEY_BUF AjustKey;
	KEY_BUF inputkey;
	repaintbg_main = true;
	scene_filelist_predraw(); //ʾڳʼʱѾ

	y0 = FL_MINILOGO_START_Y;
	for ( i = 0; i < MAX_ITEM_LINE; i++ )
	{
		FillRect( FL_LINE_SEPERATOR_X, y0 + FL_LOGO_SEPERATOR_OFFSET_Y, FL_LINE_SEPERATOR_W, FL_LINE_SEPERATOR_H, FL_LINE_SEPERATOR_COLOR, DOWN_SCREEN );
		y0 += FL_LINE_H;
	}
	Flush( DOWN_SCREEN );
	while( 1 )
	{
		while( !(Proc_GetInput( &inputkey, CONFIG_KEY_REPEAT_TIME_N )) );
		Proc_SysKeyCheck( inputkey.key );

		switch (inputkey.key)
		{
			case KEY_L:
				if( config.CategoryFlag == 0 )
					 config.CategoryFlag = 2;
				else
					config.CategoryFlag--;
				break;
			case KEY_R:
				if( config.CategoryFlag >= 2 )
					 config.CategoryFlag = 0;
				else
					config.CategoryFlag++;
				break;
		}

		//жǷ˷ѡ
		if( inputkey.key == KEY_TOUCH )
		{
			for( i = 0; i < 3; i++ )//0ȫ; 1; 2ͼƬ
			{
				AjustKey.Min_x = FL_CATEGORY_X0 + ( FL_CATEGORY_W + FL_CATEGORY_BANK ) * i;
				AjustKey.Max_x = AjustKey.Min_x + FL_CATEGORY_W;

				AjustKey.Min_y = FL_CATEGORY_Y;
				AjustKey.Max_y = FL_CATEGORY_Y + FL_CATEGORY_H;

				result = CheckValidxy( AjustKey, inputkey );
				if( result == 0 )
				{
					if( config.CategoryFlag != i )
					{
						config.CategoryFlag = i;
					}
					break;
				}
			}
		}

		if( CategoryFlag != config.CategoryFlag )
			break;
	}
	return 0;
}


void DrawFileTypeLogo( pixel *destVram, int filetype, int x0, int y0 )
{
	switch( filetype )
	{
		case fs_filetype_dir:
			bitBltFC( FolderLOGO, FL_MINILOGO_W, FL_MINILOGO_H, destVram, SCREEN_W, SCREEN_H, x0, y0, COLOR_GREEN );
			break;

		case fs_filetype_txt:
		case fs_filetype_html:
			bitBltFC( TxtLOGO, FL_MINILOGO_W, FL_MINILOGO_H, destVram, SCREEN_W, SCREEN_H, x0, y0, COLOR_GREEN );
			break;

#if ENABLE_PDF
		case fs_filetype_pdf:
			bitBltFC( PdfLOGO, FL_MINILOGO_W, FL_MINILOGO_H, destVram, SCREEN_W, SCREEN_H, x0, y0, COLOR_GREEN );
			break;
#endif

		case fs_filetype_bmp:
		case fs_filetype_tif:
		case fs_filetype_gif:
		case fs_filetype_jpg:
		case fs_filetype_png:
			bitBltFC( PicLOGO, FL_MINILOGO_W, FL_MINILOGO_H, destVram, SCREEN_W, SCREEN_H, x0, y0, COLOR_GREEN );
			break;

		case fs_filetype_zip:
			bitBltFC( ZipLOGO, FL_MINILOGO_W, FL_MINILOGO_H, destVram, SCREEN_W, SCREEN_H, x0, y0, COLOR_GREEN );
			break;

		default:
			bitBltFC( UnknowLOGO, FL_MINILOGO_W, FL_MINILOGO_H, destVram, SCREEN_W, SCREEN_H, x0, y0, COLOR_GREEN );
			break;
	}

}

void DrawFileList( p_win_menuitem item, t_win_menu_predraw predraw )
{
	int x0, y0, i;
	dword idx;
	static dword topidx = 0, botidx = 0;
	pixel *Vram = GetVram( DOWN_SCREEN );
	const byte str[3] = "..";
	const byte *pStr = NULL;
#if USE_UNICODE_FONTLIB
	byte ucs2[8];
#endif

#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, 8 );
	utf8_ucs2( str, ucs2 );
	pStr = (const byte*)ucs2;
#else
	pStr = (const byte*)str;
#endif

	if( item == NULL )
	{
		item = WinItem;
		if( item == NULL )
			return;
	}

	if ( needrp ) //--------------ػǰѡ֮е
	{
		needrp_subbg = repaintbg_sub;
		if( repaintbg_main || repaintbg_sub )
		{
			if (predraw != NULL)
			{
				predraw();//ֻԴ棬ˢĻʾ
			}
			else
			{
				scene_filelist_predraw();//ֻԴ棬ˢĻʾ
			}
		}

		{
			bufferTemp = FlVram;
			x0 = FL_MINILOGO_START_X;
			y0 = 0;
#if BG_COLOR_USE
			memsetword( FlVram, FL_LINE_BG_COLOR, FL_LINE_W * FL_LINE_H * MAX_ITEM_LINE * 3 );
#else
			for( i = 0; i < 3; i++ )
				memcpyword( FlVram + FL_LINE_W * FL_LINE_H * MAX_ITEM_LINE * i, bg_start_down + FL_MINILOGO_START_Y * SCREEN_W, FL_LINE_W * FL_LINE_H * MAX_ITEM_LINE );
#endif

			if( mbodyf == false && AlignLineFlag == true )
			{
				topidx = topindex;
				botidx = botindex;
			}
			else
			{
				if( topindex >= MAX_ITEM_LINE  )
					topidx =  topindex - MAX_ITEM_LINE;
				else
					topidx = 0;

				botidx = topidx + MAX_ITEM_LINE * 3;
				if( botidx >= countindex )
					botidx = countindex - 1;
			}
			for ( i = topidx; i <= botidx; i++ )
			{
				if( config.CategoryFlag == 1 )
					idx = TxtidxTab[i];
				else if( config.CategoryFlag == 2 )
					idx = PicidxTab[i];
				else
					idx = i;

				if( i == Index )//ǰѡ(˳ѡ)
				{
					FillRect( FL_LINE_COLORRECT_X, y0, FL_LINE_COLORRECT_W, FL_LINE_COLORRECT_H, FL_LINE_COLORRECT_COLOR, VRAMTEMP );
				}

				if( item[idx].name[0] != '.' )
				{
					DrawFileTypeLogo( FlVram, (int)(item[idx].data), x0, y0 );
//					DrawTextLine( FL_LINE_FONT_START_X, y0 + FL_LOGO_FONT_OFFSET_Y, SCREEN_W, (const byte *)item[idx].name, FL_LINE_FCOLOR, VRAMTEMP );
					CB_putnstringhorz_sys( FL_LINE_FONT_START_X,y0 + FL_LOGO_FONT_OFFSET_Y, 0, (const byte *)item[idx].name, INVALID_LEN, FL_LINE_FCOLOR, VRAMTEMP, DISP_FONTSIZE, DISP_FONTSIZE );
				}
				else
				{
					bitBltFC( RetLOGO, FL_MINILOGO_W, FL_MINILOGO_H, FlVram, SCREEN_W, SCREEN_H, x0, y0, COLOR_GREEN );//װطеʾ
					CB_putnstringhorz_sys( FL_LINE_FONT_START_X,y0 + FL_LOGO_FONT_OFFSET_Y, 0, (const byte *)pStr, INVALID_LEN, FL_LINE_FCOLOR, VRAMTEMP, DISP_FONTSIZE, DISP_FONTSIZE );
				}
				//ָ
				FillRect( FL_LINE_SEPERATOR_X, y0 + FL_LOGO_SEPERATOR_OFFSET_Y, FL_LINE_SEPERATOR_W, FL_LINE_SEPERATOR_H, FL_LINE_SEPERATOR_COLOR, VRAMTEMP );
				y0 += FL_LINE_H;
			}

			i = botidx - topidx + 1;
			for( ; i < MAX_ITEM_LINE; i++ )
			{
				FillRect( FL_LINE_SEPERATOR_X, y0 + FL_LOGO_SEPERATOR_OFFSET_Y, FL_LINE_SEPERATOR_W, FL_LINE_SEPERATOR_H, FL_LINE_SEPERATOR_COLOR, VRAMTEMP );
				y0 += FL_LINE_H;
			}
		}
		needrp = false;
	}
	else
	{
		bufferTemp = FlVram;
		//ػһѡ
		x0 = FL_MINILOGO_START_X;
		y0 = FL_LINE_H * (lastsel-topindex);
#if BG_COLOR_USE
		FillRect( FL_LINE_COLORRECT_X, y0, FL_LINE_COLORRECT_W, FL_LINE_COLORRECT_H, FL_LINE_BG_COLOR, VRAMTEMP );
#else
		memcpyword( FlVram + FL_LINE_W * y0, bg_start_down + (FL_MINILOGO_START_Y + y0) * SCREEN_W, SCREEN_W * FL_LINE_COLORRECT_H );
#endif

		if( config.CategoryFlag == 1 )
			idx = TxtidxTab[lastsel];
		else if( config.CategoryFlag == 2 )
			idx = PicidxTab[lastsel];
		else
			idx = lastsel;

		if( item[idx].name[0] != '.' )
		{
			DrawFileTypeLogo( FlVram, (int)(item[idx].data), x0, y0 );
//			DrawTextLine( FL_LINE_FONT_START_X, y0 + FL_LOGO_FONT_OFFSET_Y, SCREEN_W, (const byte *)item[idx].name, FL_LINE_FCOLOR, VRAMTEMP );
			CB_putnstringhorz_sys( FL_LINE_FONT_START_X,y0 + FL_LOGO_FONT_OFFSET_Y, 0, (const byte *)item[idx].name, INVALID_LEN, FL_LINE_FCOLOR, VRAMTEMP, DISP_FONTSIZE, DISP_FONTSIZE );
		}
		else
		{
			bitBltFC( RetLOGO, FL_MINILOGO_W, FL_MINILOGO_H, FlVram, SCREEN_W, SCREEN_H, x0, y0, COLOR_GREEN );//װطеʾ
			CB_putnstringhorz_sys( FL_LINE_FONT_START_X,y0 + FL_LOGO_FONT_OFFSET_Y, 0, (const byte *)pStr, INVALID_LEN, FL_LINE_FCOLOR, VRAMTEMP, DISP_FONTSIZE, DISP_FONTSIZE );
		}

		//ػǰѡ
		x0 = FL_MINILOGO_START_X;
		y0 = FL_LINE_H * (Index-topindex);

		FillRect( FL_LINE_COLORRECT_X, y0, FL_LINE_COLORRECT_W, FL_LINE_COLORRECT_H, FL_LINE_COLORRECT_COLOR, VRAMTEMP );
		if( config.CategoryFlag == 1 )
			idx = TxtidxTab[Index];
		else if( config.CategoryFlag == 2 )
			idx = PicidxTab[Index];
		else
			idx = Index;

		if( item[idx].name[0] != '.' )
		{
			DrawFileTypeLogo( FlVram, (int)(item[idx].data), x0, y0 );
//			DrawTextLine( FL_LINE_FONT_START_X, y0 + FL_LOGO_FONT_OFFSET_Y, SCREEN_W, (const byte *)item[idx].name, FL_LINE_FCOLOR, VRAMTEMP );
			CB_putnstringhorz_sys( FL_LINE_FONT_START_X,y0 + FL_LOGO_FONT_OFFSET_Y, 0, (const byte *)item[idx].name, INVALID_LEN, FL_LINE_FCOLOR, VRAMTEMP, DISP_FONTSIZE, DISP_FONTSIZE );
		}
		else
		{
			bitBltFC( RetLOGO, FL_MINILOGO_W, FL_MINILOGO_H, FlVram, SCREEN_W, SCREEN_H, x0, y0, COLOR_GREEN );//װطеʾ
//			DrawTextLine( FL_LINE_FONT_START_X, y0 + FL_LOGO_FONT_OFFSET_Y, SCREEN_W, (const byte *)"..", FL_LINE_FCOLOR, VRAMTEMP );
			CB_putnstringhorz_sys( FL_LINE_FONT_START_X,y0 + FL_LOGO_FONT_OFFSET_Y, 0, (const byte *)pStr, INVALID_LEN, FL_LINE_FCOLOR, VRAMTEMP, DISP_FONTSIZE, DISP_FONTSIZE );
		}
	}

	if( movey == 0 )
	{
		memcpyword( Vram+FL_MINILOGO_START_Y * SCREEN_W, FlVram + (topindex - topidx) * FL_LINE_H * FL_LINE_W, FL_LINE_W * FL_LINE_H * MAX_ITEM_LINE );
	}
	else if( movey > 0 )
	{
		s32 mv = FL_LINE_H - movey;
		dword idx;
		if( topindex > topidx )
			idx = topindex - topidx - 1;
		else
			idx = 0;
		memcpyword( Vram+FL_MINILOGO_START_Y * SCREEN_W, FlVram+mv*SCREEN_W + (idx) * FL_LINE_H * FL_LINE_W, FL_LINE_W * FL_LINE_H * MAX_ITEM_LINE );
	}
	else
	{
		s32 mv = -movey;
		memcpyword( Vram+FL_MINILOGO_START_Y * SCREEN_W, FlVram+mv*SCREEN_W + (topindex - topidx) * FL_LINE_H * FL_LINE_W, FL_LINE_W * FL_LINE_H * MAX_ITEM_LINE );
	}
}

void DrawDateTime( RTC *rtc, pixel *bgVram, int bgx, int bgy, int bgw, int bgh, BOOL flag, BOOL needupdate )//flag 1ʾ
{
//	KEY_BUF inputkey;
	RTC _rtc;
	static U8 minutes_old = 0;
	pixel *Vram = GetVram( UP_SCREEN );
	if( bgVram )
		bitBlt1( bgVram, bgw, bgh, Vram, SCREEN_W, SCREEN_H, bgx, bgy );

	if( rtc == NULL )
	{
//		ds2_getrawInput( &inputkey );
		ds2_getTime( &_rtc );
		rtc = &_rtc;
	}

	if( flag == true )
	{
		if( minutes_old == rtc->minutes )
		{
			return;
		}
	}

	minutes_old = rtc->minutes;
	ShowDateTime( rtc, -1, SUBPAN_DATETIME_Y, SUBPAN_DATETIME_FCOLOR, true, UP_SCREEN, false, 2, '-' );//ShowYeadMode 0: ʾ1ֻʾλ2겻ʾ
	if( needupdate )
		Flush( UP_SCREEN );
}

#define		VerticalFadeStepCountH		14
static const U32 VerticalFadeStepH[VerticalFadeStepCount]={2,3,4,5,6,7,8,8,7,6,5,4,3,2 };//70pixel

bool Proc_AlignLine( void )
{
	if( AlignLineFlag == false )
	{
		if( automovey > 0 )
		{
			if( movescreenflag == true || movelineflag == true )
			{
				if( movescreenflag == true )
				{
					if( stepidx < VerticalFadeStepCount )
					{
						step = VerticalFadeStep[stepidx];
						if( stepidx < VerticalFadeStepCount / 2 )
							stepidx++;
						else
						{
							if( automovey < FL_LINE_H * MAX_ITEM_LINE / 2 )
								stepidx++;
						}
					}
					else if( stepidx == VerticalFadeStepCount )
					{
						if( automovey >= 10 )
							step = 2;
						else
							step = 1;
					}
				}
				else
				{
					if( stepidx < VerticalFadeStepCountH )
					{
						step = VerticalFadeStepH[stepidx];
						if( stepidx < VerticalFadeStepCountH / 2 )
							stepidx++;
						else
						{
							if( automovey < FL_LINE_H * MAX_ITEM_LINE / 4 )
								stepidx++;
						}
					}
					else if( stepidx == VerticalFadeStepCount )
					{
						if( automovey > 5 )
							step = 2;
						else
							step = 1;
					}
				}
				if( automovey < step )
					step = 1;
				automovey -= step;
				movey += step;
				if( movey >= FL_LINE_H )
				{
					movey -= FL_LINE_H;
					if( topindex > 0 )
					{
						topindex--;
						botindex--;
						if( topindex == 0 )
						{
							movey = 0;
							AlignLineFlag = true;
						}
					}
				}
			}
			else
			{
				if( automovey >= (FL_LINE_H / 2) )
				{
					automovey++;
					if( automovey == FL_LINE_H )
					{
						if( topindex > 0 )
						{
							topindex--;
							botindex--;
						}
						automovey = 0;
						AlignLineFlag = true;
					}
				}
				else if( automovey < (FL_LINE_H / 2) )
				{
					automovey--;
					if( automovey == 0 )
					{
						AlignLineFlag = true;
					}
				}
			}
		}
		else if( automovey < 0 )
		{
			if( movescreenflag == true || movelineflag == true )
			{
				if( movescreenflag == true )
				{
					if( stepidx < VerticalFadeStepCount )
					{
						step = VerticalFadeStep[stepidx];
						if( stepidx < VerticalFadeStepCount / 2 )
							stepidx++;
						else
						{
							if( automovey >= (-FL_LINE_H * MAX_ITEM_LINE / 2) )
								stepidx++;
						}
					}
					else if( stepidx == VerticalFadeStepCount )
					{
						if( automovey <= -10 )
							step = 2;
						else
							step = 1;
					}
				}
				else
				{
					if( stepidx < VerticalFadeStepCountH )
					{
						step = VerticalFadeStepH[stepidx];
						if( stepidx < VerticalFadeStepCountH / 2 )
							stepidx++;
						else
						{
							if( automovey >= (-FL_LINE_H * MAX_ITEM_LINE / 4) )
								stepidx++;
						}
					}
					else if( stepidx == VerticalFadeStepCount )
					{
						if( automovey <= -10 )
							step = 2;
						else
							step = 1;
					}
				}

				if( abs(automovey) < step )
					step = 1;
				automovey += step;
				movey -= step;
				if( movey <= -FL_LINE_H )
				{
					movey += FL_LINE_H;
					if( botindex < countindex - 1 )
					{
						topindex++;
						botindex++;
						if( botindex == countindex - 1 )
						{
							movey = 0;
							AlignLineFlag = true;
						}
					}
				}
			}
			else
			{
				{
					if( automovey <= (-(FL_LINE_H / 2)) )
					{
						automovey--;
						if( automovey == -FL_LINE_H )
						{
							if( botindex < countindex - 1 )
							{
								topindex++;
								botindex++;
							}
							automovey = 0;
							AlignLineFlag = true;
						}
					}
					else if( automovey > (-(FL_LINE_H / 2)) )
					{
						automovey++;
						if( automovey == 0 )
						{
							AlignLineFlag = true;
						}
					}
					movey = automovey;
				}
			}
		}
		else
		{
			AlignLineFlag = true;
		}
		return true;
	}
	return false;
}

extern dword win_menu_Specific( dword x, dword y, dword max_width, dword max_height,
					  p_win_menuitem item, dword countAll, dword initindex,
					  dword linespace, pixel bgcolor, BOOL redraw,
					  t_win_menu_predraw predraw, t_win_menu_draw postdraw,
					  t_win_menu_callback cb, BOOL KeyWaitIsValid ) //initindex: ѡ //count:Ŀ
{
//------------------------ֲ----------------------------------
	int RetValue = INVALID;
	t_win_menu_op op = win_menu_op_redraw;
	dword i;
	KEY_BUF inputkey;
	int result;
	bool KeyPressFlag = false;
	dword count = countAll;
	bool CategoryMemFlag = false;//ΪĿ¼Ƿɹ־ 1:ɹ
	dword countTxt = 0;
	dword count_txt = 0;
	dword countPic = 0;
	dword count_pic = 0;
	int CategoryFlag_old = config.CategoryFlag;
	bool ToplevelFlag;
	lastsel = Index = initindex;
	WinItem = item;
	
	if( stricmp( config.Upath, CONFIG_ROOTDIR ) == 0 )
		ToplevelFlag = true;
	else
		ToplevelFlag = false;

	//
	for( i = 0; i < countAll; i++ )
	{
		switch ( (dword)item[i].data )
		{
			case fs_filetype_dir://ļ
			case fs_filetype_zip://zipļ
				countTxt++;
				countPic++;
				break;

			case fs_filetype_txt:
			case fs_filetype_html:
#if ENABLE_PDF
			case fs_filetype_pdf:
#endif
				countTxt++;
				break;

			case fs_filetype_bmp:
			case fs_filetype_tif:
			case fs_filetype_gif:
			case fs_filetype_jpg:
			case fs_filetype_png:
				countPic++;
				break;
		}
	}
	
	if( countTxt > 0 )
		TxtidxTab = memalign( sizeof(dword), sizeof(dword) * countTxt );
	if( countPic > 0 )
		PicidxTab = memalign( sizeof(dword), sizeof(dword) * countPic );
	
	if( countTxt > 0 || countPic > 0 )
	{
		if( countTxt > 0 && TxtidxTab == NULL )
			goto _WIN_LOOP;

		if( countPic > 0 && PicidxTab == NULL )
			goto _WIN_LOOP;

//		if( TxtidxTab != NULL && PicidxTab != NULL )
		{
			count_txt = 0;
			count_pic = 0;

			if( ToplevelFlag == false )//ʾ
			{
				if( TxtidxTab != NULL )
					TxtidxTab[count_txt++] = 0;//Ϸ
				if( PicidxTab != NULL )
					PicidxTab[count_pic++] = 0;//Ϸ
				if( count_txt == countTxt && count_pic == countPic )
				{
					CategoryMemFlag = true;
					goto _WIN_LOOP;
				}
			}

			for( i = 0; i < countAll; i++ )
			{
				switch ( (U32)item[i].data )
				{
					case fs_filetype_txt:
					case fs_filetype_html:
#if ENABLE_PDF
					case fs_filetype_pdf:
#endif
						TxtidxTab[count_txt++] = i;
						break;

					case fs_filetype_bmp:
					case fs_filetype_tif:
					case fs_filetype_gif:
					case fs_filetype_jpg:
					case fs_filetype_png:
						PicidxTab[count_pic++] = i;
						break;
				}
			}

			//ļзں
			if( ToplevelFlag == false )//Ƕ㣬ڷǰѾ
				i = 1;
			else
				i = 0;
			for( ; i < countAll; i++ )
			{
				if( (t_fs_filetype)item[i].data == fs_filetype_dir )//ļ
				{
					TxtidxTab[count_txt++] = i;
					PicidxTab[count_pic++] = i;
				}
				else if( (t_fs_filetype)item[i].data == fs_filetype_zip )//zipļ
				{
					TxtidxTab[count_txt++] = i;
					PicidxTab[count_pic++] = i;
				}
			}

			CategoryMemFlag = true;
		}
	}
	else if( countTxt == 0 && countPic == 0 )
		CategoryMemFlag = true;

_WIN_LOOP:
	if( CategoryMemFlag == true )
	{
		if( config.CategoryFlag == 1 )
		{
			count = countTxt;
			if( count > 0 )
			{
				for( i = 0; i < count; i++ )
				{
					if( TxtidxTab[i] == Index )//ת
					{
						Index = i;
						break;
					}
				}
				if( i == count )
					Index = 0;
			}
		}
		else if( config.CategoryFlag == 2 )
		{
			count = countPic;
			if( count > 0 )
			{
				for( i = 0; i < count; i++ )
				{
					if( PicidxTab[i] == Index )//ת
					{
						Index = i;
						break;
					}
				}
				if( i == count )
					Index = 0;
			}
		}
		else
		{
			count = countAll;
		}

		if( config.CategoryFlag == 0 )
		{
			if( CategoryFlag_old != config.CategoryFlag )
			{
				if( CategoryFlag_old == 1 )	//ת
				{
					if( countTxt > 0 )
						Index = TxtidxTab[Index];
				}
				else if( CategoryFlag_old == 2 )
				{
					if( countPic > 0 )
						Index = PicidxTab[Index];
				}
				else
					Index = 0;
			}
		}
	}
	else
	{
		count = countAll;
		config.CategoryFlag = 0;
	}

	CategoryFlag_old = config.CategoryFlag;

	if( count != 0 && Index >= count )
		Index = 0;

	if( count == 0 )
	{
		result = ProcessItemNull( config.CategoryFlag );
		if( result == 0 )
			goto _WIN_LOOP;
	}

#define		VRAMBUFFER_ITEM_COUNT	( 	MAX_ITEM_LINE*3	 )
#define		VRAMBUFFER_W			(	FL_LINE_W	)
#define		VRAMBUFFER_H			(	FL_LINE_H *	VRAMBUFFER_ITEM_COUNT )

#if USE_DYNAMIC_VRAMBUFFER

	pixel *FlVram = (pixel*)memalign( sizeof( pixel ), VRAMBUFFER_W * VRAMBUFFER_H );

#endif

//---------------------------------------------------------------------
	if (cb == NULL)
		cb = win_menu_defcb2;

	topindex = (Index >= max_height) ? (Index - max_height + 1) : 0;//Index: ѡ
	botindex = (topindex + max_height > count) ? (count - 1) : (topindex + max_height - 1);//count:Ŀ
	repaintbg_main = true;

#define			COLORBLOCK_ADJUST_W			( FL_NAVIGATIONBAR_W + FL_NAVIGATION_BANK )
	
	RTC rtc;
	int datetime_bg_startx = NOTICE_HELP_LOGO_X +  NOTICE_HELP_LOGO_W;
	int datetime_bg_w = notice_exit_font_x - datetime_bg_startx;
	pixel *TimeBuf = memalign( sizeof( pixel ), sizeof( pixel ) * datetime_bg_w * SUBPAN_TIME_H );
	
	int Need_Reset_Key = true;

	if( TimeBuf )
		bitBlt2( bg_start_up, SCREEN_W, SCREEN_H, datetime_bg_startx, SUBPAN_DATETIME_Y, TimeBuf, datetime_bg_w, SUBPAN_TIME_H, 0, 0 );

	if( bookfontindex_cur != 0 )
	{
		if( scene_load_book_font( 0 ) )//ָ
			recalcSize(&drperpage, &rowsperpage, &pixelsperrow);
	}
	countindex = count;
	repaintbg_main = true;
	needrp_subbg = true;
	needrp = true;
	mbodyf = false;
	movey = 0;
	AlignLineFlag = true;
	
	while( 1 )
	{
_WIN_MENU_LOOP_START:

		DrawFileList( item, predraw );
		DrawSlide( Index, count, DOWN_SCREEN );//
		Flush( DOWN_SCREEN );

		if( needrp_subbg )
		{
			DrawDateTime( NULL, TimeBuf, datetime_bg_startx, SUBPAN_DATETIME_Y, datetime_bg_w, SUBPAN_TIME_H, false, true );
			needrp_subbg = false;
		}

		if( KeyWaitIsValid == FALSE )
		{
			RetValue = Index;
			goto _WIN_MENU_EXIT;
		}

		lastsel = Index;
		do
		{
			do{
				ds2_getTime( &rtc );
				DrawDateTime( &rtc, TimeBuf, datetime_bg_startx, SUBPAN_DATETIME_Y, datetime_bg_w, SUBPAN_TIME_H, true, true );
				do{
					ds2_getrawInput( &inputkey );
					
					if( inputkey.key == 0 )
					{	
						Need_Reset_Key = true;
					}
						
					Proc_SysKeyCheck( inputkey.key );
					result = Proc_TouchPad( inputkey );
					
				}while( mbodyf == true && result == 0 );
				if( result )
				{
					if( result == 1 )
					{
						op = win_menu_op_redraw;
						needrp = true;
						goto _WIN_MENU_LOOP_START;
					}
					else if( result == 2 )
					{
						op = win_menu_op_ok;
						goto _WIN_MENU_NEXT;
					}
				}
				else
				{
					if( Proc_AlignLine() == true )
					{
						needrp = true;
						goto _WIN_MENU_LOOP_START;
					}
				}
				KeyPressFlag = Proc_GetInputAcc( &inputkey, 250, 10, KEY_UP|KEY_DOWN|KEY_LEFT|KEY_RIGHT, 4, true, Need_Reset_Key  );//input_repeat_time
				Need_Reset_Key = false;
				if( inputkey.key == KEY_L || inputkey.key == KEY_R )
					ctrl_waitrelease( inputkey.key );

			}while( inputkey.key == 0 || KeyPressFlag == false );

			if( mbodyf == false )
			{
				op = cb( inputkey, item, &count, max_height, &topindex, &Index );
			}
		}while( op == win_menu_op_continue );

//---------------------------------------------------------------------------------------------------------
_WIN_MENU_NEXT:
		switch(op)
		{
			case win_menu_op_ok:
				RetValue = Index;
				goto _WIN_MENU_EXIT;
			case win_menu_op_cancel:
				RetValue = INVALID;
				goto _WIN_MENU_EXIT;
			case win_menu_op_force_redraw:
				needrp = true;
				break;
			case win_menu_op_redraw:
				break;
			case win_menu_op_back:
				if( config.CategoryFlag == 0 )
					Index = 0;
				RetValue = Index;
				goto _WIN_MENU_EXIT;
			case win_menu_op_force_redraw_bg:
				needrp = true;
				goto _WIN_LOOP;
			default:;
		}

		{
			if ( Index > botindex )
			{
				topindex = Index - max_height + 1;
				botindex = Index;
				needrp = true;
			}
			else if (Index < topindex)
			{
				topindex = Index;
				botindex = topindex + max_height - 1;
				needrp = true;
			}
		}
	}//while (1)

_WIN_MENU_EXIT:
	if( RetValue >= 0 )//
	{
		if( config.CategoryFlag == 1 )//
			RetValue = TxtidxTab[RetValue];
		else if( config.CategoryFlag == 2 )//ͼƬ
			RetValue = PicidxTab[RetValue];
	}
	if( TxtidxTab )
	{
		free( TxtidxTab );
		TxtidxTab = NULL;
	}
	if( PicidxTab )
	{
		free( PicidxTab );
		PicidxTab = NULL;
	}

#if USE_DYNAMIC_VRAMBUFFER
	if( FlVram )
		free( FlVram );
#endif
	if( TimeBuf )
		free( TimeBuf );

	return RetValue;
}

extern void win_msg(const char *prompt, pixel fontcolor, pixel bordercolor, pixel bgcolor)
{
	int key = 0;
	int x1, y1, x2, y2, x0, y0;
	dword width = strlen(prompt);

	width = text_get_string_width_sys( (const byte*)prompt, width, 0 );

#define  BORDER_SPACE  20

	x1 = SCREEN_W / 2 - width / 2;
	x2 = SCREEN_W / 2 + width / 2 + BORDER_SPACE;

	y1 = SCREEN_H / 2 - DISP_FONTSIZE / 2;
	y2 = SCREEN_H / 2 + DISP_FONTSIZE / 2 + BORDER_SPACE;

	CHECK_AND_VALID( x1, y1 );
	CHECK_AND_VALID( x2, y2 );

	x0 = x1 - BORDER_SPACE;
	y0 = y1 - BORDER_SPACE;

	CHECK_AND_VALID( x0, y0 );


#define  WIN_MSG_PAN 		DOWN_SCREEN
	FillRect2( x0, y0, x2, y2, bgcolor, WIN_MSG_PAN );
	DrawRect2( x0, y0, x2, y2, bordercolor, WIN_MSG_PAN );
	DrawRectText( x1, y1, x2-x1, y2-y1, 0, 0, (const unsigned char*)prompt, fontcolor, WIN_MSG_PAN );
	Flush( WIN_MSG_PAN );
	while ( 1 )
	{
		while( !(key = Proc_GetKey( CONFIG_KEY_REPEAT_TIME_N )) );
		if( key == KEY_A || key == KEY_B )
			break;
	}

	return;
}

extern p_win_menuitem win_realloc_items(p_win_menuitem item, int orgsize, int newsize)
{
	item = (p_win_menuitem) realloc_free_when_fail( item, sizeof(t_win_menuitem) * newsize );
	if (item == NULL)
		return NULL;
	return item;
}

extern void win_item_destroy(p_win_menuitem * item, dword * size)
{
	if (item == NULL || *item == NULL || size == 0) {
		return;
	}
	free(*item);
	*size = 0;
	*item = NULL;
}

extern p_win_menuitem win_copy_item(p_win_menuitem dst, const p_win_menuitem src)
{
	if (dst == NULL || src == NULL)
		return NULL;

//	buffer_copy_string(dst->compname, src->compname->ptr);
//	buffer_copy_string(dst->shortname, src->shortname->ptr);
	STRCPY_S(dst->name, src->name);
	dst->width = src->width;
//	dst->icolor = src->icolor;
//	dst->selicolor = src->selicolor;
//	dst->selrcolor = src->selrcolor;
//	dst->selbcolor = src->selbcolor;
//	dst->selected = src->selected;
	dst->data = src->data;
	size_t i;

	for (i = 0; i < 4; ++i) {
		dst->data2[i] = src->data2[i];
	}
	dst->data3 = src->data3;
	return dst;
}

static BOOL FileList_MouseDown( s32 x,s32 y )
{
	mb=true;
	msx=x;
	msy=y;
	mx=x;
	my=y;
	movespeed=0;
	mvsynccnt=0;

	movey = 0;
	movescreenflag = false;
	movelineflag = false;

	dword idx = topindex + ( y - FL_MINILOGO_START_Y ) / FL_LINE_H;
	if( idx >= topindex && idx <= botindex )
	{
		Index = idx;
		return true;
	}
	return false;
}

static BOOL FileList_MouseMove( s32 x,s32 y )
{
	int result = false;
	if(mb==false) return(false);

	if( countindex <= MAX_ITEM_LINE )
		return(false);

	if(y!=my){

		s32 vec=my-y;
	    if(movespeed<vec){
	      movespeed=vec;
	      }else{
	      movespeed=(movespeed+(vec*15))/16;
	    }

		s32 mv=y-mbodyy;
		s32 h = FL_LINE_H;
		s32 v = 0;
		while(mv<=-h)//
		{
			v++;
			mv+=h;//뵽
			mbodyy-=h;
		}
		while(h<=mv)//
		{
			v--;
			mv-=h;//뵽
			mbodyy+=h;
		}
		movey = mv;
		if( v != 0 )
		{
			s32 topidx = topindex;
			s32 botidx = botindex;

			if( v > 0 && botidx >= countindex - 1 ) return false;
			if( v < 0 && topidx == 0 ) { movey = 0; return false; }
			topidx += v;
			botidx += v;
			while( topidx < 0 )
			{
				topidx++;
				botidx++;
			}
			while( botidx >= countindex )
			{
				topidx--;
				botidx--;
			}
			topindex = topidx;
			botindex = botidx;
			needrp = true;
		}

		if( topindex == 0 )
		{
			if( movey > 0 )
				movey = 0;
		}
		else if( botindex == countindex - 1 )
		{
			if( movey < 0 )
				movey = 0;
		}

		result = true;
	}

	mx=x;
	my=y;

return(result);
}

static BOOL CB_MouseDown( s32 x,s32 y )
{
	mbodyf=false;
	ts_count = 0;

	AJUST_KEY_BUF AjustKey;
	KEY_BUF inputkey;

	inputkey.x = x;
	inputkey.y = y;

	//
	AjustKey.Min_x = FL_SLIDE_X - 10;
	AjustKey.Max_x = SCREEN_W - 1;

	AjustKey.Min_y = FL_SLIDE_Y - 5;
	AjustKey.Max_y = FL_SLIDE_MAX_Y + FL_SLIDE_H + 5;
	if( CheckValidxy( AjustKey, inputkey ) == 0 )
	{
		mscrf = true;
		return false;
	}

	//ļб
	AjustKey.Min_x = 0;
	AjustKey.Max_x = FL_SLIDE_X - 20;

	AjustKey.Min_y = FL_MINILOGO_START_Y;
	AjustKey.Max_y = AjustKey.Min_y + FL_LINE_H * MAX_ITEM_LINE;
	if( CheckValidxy( AjustKey, inputkey ) == 0 )
	{
		if( FileList_MouseDown( x, y ) == false )return false;
	}
	else
	{
		return false;
	}

	mbodyf=true;
	mbodyy=y;
	mbodyx=x;

	msx=x;
  	msy=y;

	return true;
}

static BOOL CB_MouseMove(s32 x,s32 y)
{
	if( mscrf == true )return false;
	int result = FileList_MouseMove( x, y );
	return result;
}

static int CB_MouseUp(s32 x,s32 y)
{
	int result = 0;

	if( mbodyf == true )
	{
		if( (-5<(y-msy))&&((y-msy)<5) )
		{
			result = 2;
	    }
		if( movey == 0 && (topindex == 0 || botindex == countindex - 1) ){
			automovey = 0;
		}
		else{
			automovey = movespeed * 10;
			automovey = -automovey;//תΪͬ
			automovey += movey;//ͬ
		}

		if( automovey != 0 )
			AlignLineFlag = false;
		if( AlignLineFlag == false )
		{
			if( abs(automovey) >= FL_LINE_H * MAX_ITEM_LINE )
			{
				movescreenflag = true;
				stepidx = VerticalFadeStepCount / 2;
			}
			else if( abs(automovey) >= FL_LINE_H )
			{
				movelineflag = true;
				stepidx = VerticalFadeStepCountH / 2;
			}

			if( movescreenflag == true || movelineflag == true )
			{
				movey = 0;
				if( automovey > 0 )
				{
					automovey = (automovey + FL_LINE_H / 2) / FL_LINE_H;//
					automovey = automovey * FL_LINE_H;//
				}
				else if( automovey < 0 )
				{
					automovey = (automovey - FL_LINE_H / 2) / FL_LINE_H;//
					automovey = automovey * FL_LINE_H;//
				}
			}
		}
	}

	mscrf = false;
	mbodyf=false;
	mbodyx=0;
	mbodyy=0;

	return result;
}

static int Proc_TouchPad( KEY_BUF inputkey )
{
	BOOL tpress;
  	s32 tx,ty;
  	int result = false;

  	if( (inputkey.key & KEY_TOUCH) == 0 )
  	{
    	tpress=false;
    	tx=0;
    	ty=0;
   	}
   	else
   	{
    	tpress=true;
    	tx=inputkey.x;
    	ty=inputkey.y;
  	}

  if(tpress==true){
    if(mf==false){
      mf=true;
      result = CB_MouseDown(tx,ty);
      mx=tx;
      my=ty;
      }else{
      s32 dx=abs(mx-tx);
      s32 dy=abs(my-ty);
      if((1<=dx)||(1<=dy)){
        result=CB_MouseMove(tx,ty);
      }
      else{
	  }
    }
    }else{
    if(mf==true){
      mf=false;
      result = CB_MouseUp(mx,my);
    }
  }

  return result;
}
