/* vim:set ts=4 sw=4 cindent ignorecase enc=gbk: */

#ifndef _WIN_H_
#define _WIN_H_

#include "common/datatype.h"
#include "display.h"
#include "buffer.h"
#include <ds2io2.h>
#include <gdi.h>
#include <config_ebook.h>

extern pixel *Ret_UnselectLine_Buf;
extern pixel *Ret_SelectLine_Buf;

extern pixel FLNavigationBuf[FL_NAVIGATIONBAR_W*FL_NAVIGATIONBAR_H];//
extern pixel FLSlideBuf[FL_SLIDE_W*FL_SLIDE_H];//


// Menu item structure
typedef struct
{
//	buffer *compname;// ļȫ
//	buffer *shortname;
//	buffer *longname;// ļȫ
	char Uname[STR_DEFAULT_LEN];// ļȫ(UTF8)
	char name[STR_DEFAULT_LEN];				// item name(unicode)
	dword width;				// display width in bytes (for align/span)
//	pixel icolor;				// font color
//	pixel selicolor;			// selected font color
//	pixel selrcolor;			// selected rectangle line color
//	pixel selbcolor;			// selected background filling color
	BOOL selected;				// item selected
	void *data;					// custom data for user processing ļʹ,ļʹfs.hж
	word data2[4]; ///ʱ ޸/ʱ
	dword data3;//ļ
//	word attr; //ļ add by LHM 2010-5-18 15:13:05
	dword idx;//ļб,ڵǰʾͼƬʱĲѯ
} t_win_menuitem, *p_win_menuitem;

typedef struct{
	dword index;//ǰ
	dword topindex;//
	dword botindex;//
	dword count;//
}FL_MENUITEM;

// Menu callback
typedef enum
{
	win_menu_op_continue = 0,
	win_menu_op_redraw,
	win_menu_op_ok,
	win_menu_op_cancel,
	win_menu_op_force_redraw,
	win_menu_op_continue_touch,
	win_menu_op_back,
	win_menu_op_force_redraw_bg,
} t_win_menu_op;
typedef t_win_menu_op(*t_win_menu_callback) (KEY_BUF inputkey, p_win_menuitem item,
											 dword * count, dword page_count,
											 dword * topindex, dword * index);
typedef void (*t_win_menu_draw) (p_win_menuitem item, dword index,dword topindex, dword max_height);
typedef void (*t_win_menu_predraw) ( void );

// Default callback for menu
extern t_win_menu_op win_menu_defcb( dword key, p_win_menuitem item,
									dword * count, dword page_count,
									dword * topindex, dword * index);

// Menu show & wait for input with callback supported
extern dword win_menu_Specific(dword x, dword y, dword max_width, dword max_height,
					  p_win_menuitem item, dword count, dword initindex,
					  dword linespace, pixel bgcolor, BOOL redraw,
					  t_win_menu_predraw predraw, t_win_menu_draw postdraw,
					  t_win_menu_callback cb, BOOL KeyWaitIsValid );

// Messagebox with yes/no
extern BOOL win_msgbox(const char *prompt, const char *yesstr,
					   const char *nostr, pixel fontcolor, pixel bordercolor,
					   pixel bgcolor);

// Message with any key pressed to close
extern void win_msg(const char *prompt, pixel fontcolor, pixel bordercolor,
					pixel bgcolor);

extern void win_item_destroy(p_win_menuitem * item, dword * size);
extern p_win_menuitem win_realloc_items(p_win_menuitem item, int orgsize,
										int newsize);
extern p_win_menuitem win_copy_item(p_win_menuitem dst,
									const p_win_menuitem src);

#define win_menu( x, y, max_width, max_height, item, count, initindex,	linespace, bgcolor, redraw, predraw, postdraw, cb ) \
		win_menu_Specific( x, y, max_width, max_height, item, count, initindex,	linespace, bgcolor, redraw, predraw, postdraw, cb, TRUE )

#define win_menu2( x, y, max_width, max_height, item, count, initindex,	linespace, bgcolor, redraw, predraw, postdraw, cb ) \
		win_menu_Specific( x, y, max_width, max_height, item, count, initindex,	linespace, bgcolor, redraw, predraw, postdraw, cb, FALSE )

KEY_BUF Proc_KeyDelay( KEY_BUF inputkey );
KEY_BUF Proc_KeyDelay2( KEY_BUF inputkey, int delay_count,  int speed_change_count );
KEY_BUF Proc_KeyDelay3( KEY_BUF inputkey, int delay_count, int speed_change_delay_count, int speed_change_count );

void ShowDateTime(  RTC *rtc, int x0, int y0, pixel color, BOOL Isbookfontsize, SCREEN_ID engine, BOOL IsShowSecond, int ShowYeadMode, char Year_Separator );//ShowYeadMode 0: ʾ1ֻʾλ2겻ʾ
		
#endif
