# ------------------------------
CC	:= $(CROSS)mipsel-linux-gcc
AR	:= $(CROSS)mipsel-linux-ar rcsv
LD	:= $(CROSS)mipsel-linux-ld
OBJCOPY	:= $(CROSS)mipsel-linux-objcopy
NM	:= $(CROSS)mipsel-linux-nm
OBJDUMP	:= $(CROSS)mipsel-linux-objdump

CFLAGS	:= -Wall -mips32 -O3 -mno-abicalls -fno-pic -fno-builtin \
	   -fno-exceptions -ffunction-sections -mlong-calls\
	   -fomit-frame-pointer -msoft-float -G 4 #-G 0

#LIBS	:= -lstdc++ -lc -lm -lgcc
LIBS	:= -lc -lm -lgcc

TOPDIR	:= ..
LIBDIR	:= $(DS2SDKPATH)/lib
LIBSRC_DIR	:= $(DS2SDKPATH)/libsrc


EXAMPLE_DIR = $(DS2SDKPATH)/example
FS_DIR = $(DS2SDKPATH)/libsrc/fs
CONSOLE_DIR = $(DS2SDKPATH)/libsrc/console
KEY_DIR = $(DS2SDKPATH)/libsrc/key
EBOOKDIR := $(TOPDIR)/ebook

#LIBS 	+= $(wildcard $(LIBDIR)/*.a)
LIBS 	+= $(LIBDIR)/libds2b.a
EXTLIBS := $(LIBDIR)/libds2a.a
CFLAGS	+=	-I$(DS2SDKPATH)/include

CFLAGS += -I../include -I$(FS_DIR) -I$(CONSOLE_DIR)# -I$(KEY_DIR)

all:	$(APP)

FS_ENABLE  = 0
########################################################
######################fslib#############################
########################################################
ifeq ($(FS_ENABLE),1)
include $(LIBSRC_DIR)/fs/fs2.mk
endif


EXAMPLE_ENABLE  = 0
########################################################
######################example###########################
########################################################
ifeq ($(EXAMPLE_ENABLE),1)
include $(EXAMPLE_DIR)/example.mk
endif

EBOOK_ENABLE  = 1
########################################################
######################ebook#############################
########################################################
ifeq ($(EBOOK_ENABLE),1)
include $(EBOOKDIR)/ebook.mk
endif


CFLAGS	+= -DEBOOK_ENABLE=$(EBOOK_ENABLE)
