/* ds2_main.c
 *
 * Copyright (C) 2010 dking <dking024@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public Licens e as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <stdio.h>
#include "console.h"
#include "fs_api.h"
#include "ds2io.h"
#include "ds2_timer.h"
#include "ds2_malloc.h"

#define BLACK_COLOR		RGB15(0, 0, 0)
#define WHITE_COLOR		RGB15(31, 31, 31)

extern int sfc_main (int argc, char **argv);

#if 0
void ddump_mem(unsigned char* addr, unsigned int len)
{
	unsigned int i;

	for(i= 0; i < len; i++)
	{
		if(i%16 == 0) cprintf("\n%08x: ", i);
		cprintf("%02x ", addr[i]);
	}
}
#endif

/*
unsigned int f_t;

void timer0handle(int arg)
{
	unsigned int c_t;

	c_t = getSysTime();
cprintf("t %d\n", c_t-f_t);
	f_t= c_t;
}
*/

void ds2_main(void)
{
	int err;
ds2_setCPUclocklevel(13);
	//Initial video and audio and other input and output
	err = ds2io_initb(512, 22050, 0, 0);
	if(err) goto _failure;

	//Initial console for printf funciton
	//err = ConsoleInit(WHITE_COLOR, BLACK_COLOR, UP_SCREEN, 10);
	//if(err) goto _failure;

	//Initial file system
	err = fat_init();
	if(err) goto _failure;

/*
unsigned char buff[0x10000];
FILE* fp;
fp = fopen("fat:/ftst.ain", "w");
if(NULL == fp)
goto _failure;

unsigned int m, n;
for(m = 0; m < 0x10000; m++)
{
	if(m %512 == 0) 	buff[m] = m/512;
	else buff[m] = m;
}

//fwrite((void*)buff, 1, 511, fp);
//fseek(fp, 0, SEEK_END);
fwrite((void*)&buff[0], 1, 0x3000, fp);
fwrite((void*)&buff[0x4000], 1, 0x4000, fp);
fclose(fp);
cprintf("over\n");
while(1);
*/

	//initTimer(0, unsigned int period, void (*handle)(unsigned int), int arg);
	//initTimer(0, 1000000/60, timer0handle, 0);
/*
	initTimer(0, 55000, timer0handle, 0);
	f_t = getSysTime();
	runTimer(0);

unsigned int c_t;
while(1)
{
mdelay(1);
}
*/
	//go to user main funtion
	sfc_main (0, 0);

_failure:
	ds2_plug_exit();
}

