/*---------------------------------------------------------------------------------


Copyright (C) 2007 Acekard, www.acekard.com

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.


---------------------------------------------------------------------------------*/

#include <nds.h>

#include <nds/bios.h>
#include <nds/arm7/touch.h>
#include <nds/arm7/clock.h>

#include "../../ipc6.h"


#include "brightnesscontrol.h"
#include "suspendcontrol.h"
#include "../../share/timetool.h"
#include "../../share/ipctool.h"
#include "../../share/memtool.h"
#include "load_nds_rom_code_bin.h"
#include <string.h>
#include "_console.h"

#ifdef __cplusplus
extern "C" {
#endif
extern void load_audio(u32 len,int format,u32 address);
extern void fix_audio(u32 d1,u32 d2,u32 d3);
#ifdef __cplusplus
}
#endif

	#define min(x, y)	(((x)<(y))?(x):(y))
	#define max(x, y)	(((x)>(y))?(x):(y))
#define enabledmaread 0

#define waitMs(t) swiDelay( 8 * 1000 * t )

void MemSet16DMA3(u16 v,void *dst,u32 len)
{
//  MemSet16CPU(v,dst,len);return;

  static vu32 dmatmp;
  dmatmp=v | (((u32)v) << 16);
  
  while((DMA3_CR&DMA_BUSY)!=0);
  DMA3_SRC = (u32)&dmatmp;
  DMA3_DEST = (u32)dst;
  DMA3_CR=(DMA_16_BIT | DMA_ENABLE | DMA_START_NOW | DMA_SRC_FIX | DMA_DST_INC)+(len>>1);
  while((DMA3_CR&DMA_BUSY)!=0);
}
void MemCopy16DMA3(void *src,void *dst,u32 len)
{
//  MemCopy16CPU(src,dst,len);return;
  while((DMA3_CR&DMA_BUSY)!=0);
  DMA3_SRC = (u32)src;
  DMA3_DEST = (u32)dst;
  DMA3_CR=(DMA_16_BIT | DMA_ENABLE | DMA_START_NOW | DMA_SRC_INC | DMA_DST_INC)+(len>>1);
  while((DMA3_CR&DMA_BUSY)!=0);
}

u8* strpcmL[4];
u8* strpcmR[4];
int l_vol,r_vol,mix_vol;

touchPosition tempPos;

void VcountHandler(void) {
//---------------------------------------------------------------------------------
    //static int heartbeat = 0;
	//static int lastbut = -1;
    IPC8->ipc_arm7_w_busy=1;
    if (IPC8->ipc_arm9_r_busy == 1)
    {
        IPC8->ipc_arm7_w_busy=0;
        return;
    }



    uint16 but=0, x=0, y=0, xpx=0, ypx=0;//, z1=0, z2=0, batt=0, aux=0;
    int t1=0, t2=0;
    uint32 temp=0;
    uint8 ct[sizeof(IPC->time.curtime)];
    u32 i;

    // Update the heartbeat
    //heartbeat++;

    // Read the touch screen
	but = REG_KEYXY;
    if (!(but & (1<<6))) {

        tempPos = touchReadXY();

        x = tempPos.x;
        y = tempPos.y;
        xpx = tempPos.px;
        ypx = tempPos.py;
    }
    //z1 = touchRead(TSC_MEASURE_Z1);
    //z2 = touchRead(TSC_MEASURE_Z2);


    //batt = touchRead(TSC_MEASURE_BATTERY);
    //aux  = touchRead(TSC_MEASURE_AUX);

    // Read the date and the time
    ct[0] = 0;
    rtcGetTimeAndDate((uint8 *)ct + 1);

    // Read the temperature
    temp = touchReadTemperature(&t1, &t2);

    // Update the IPC struct
    //IPC->heartbeat    = heartbeat;
    IPC->buttons        = but;
    IPC->touchX            = x;
    IPC->touchY            = y;
    IPC->touchXpx        = xpx;
    IPC->touchYpx        = ypx;
    //IPC->touchZ1        = z1;
    //IPC->touchZ2        = z2;
    //IPC->battery        = batt;
    //IPC->aux            = aux;

    for(i=0; i<sizeof(ct); i++) {
        IPC->time.curtime[i] = ct[i];
    }

    IPC->temperature = temp;
    IPC->tdiode1 = t1;
    IPC->tdiode2 = t2;
    IPC8->ipc_arm7_w_busy=0;
}
extern u32 strpcmVolume64;
void set_audio_vol(u32 data)
{
#ifdef ENABLE_DEBUG  
      _consolePrintf("set_audio_vol data=%x\n",data);
#endif
    l_vol=(data>>16) &0xff ;l_vol =min(l_vol,0x7f);
    r_vol=(data>>8) &0xff;r_vol=min(r_vol,0x7f);
    mix_vol=(data) &0xff;
    if (mix_vol >= 0x80 )
    {
        strpcmVolume64 = mix_vol & 0x7f;
        strpcmVolume64 = strpcmVolume64 /2;
        strpcmVolume64 += 0x40;
        mix_vol = 0x7f;
    }
    else
    {
        strpcmVolume64 = 0;
    }
    mix_vol =min(mix_vol,0x7f);
    SOUND_CR = SOUND_ENABLE | SOUND_VOL(mix_vol);
#ifdef ENABLE_DEBUG  
      _consolePrintf("strpcmVolume64=%x\nmix_vol=%x\n",strpcmVolume64,mix_vol);
#endif

}
static void prepairReset()
{
    powerON(POWER_SOUND);

    //reset DMA
    zeroMemory( (void *)0x40000B0, 0x30 );

    REG_IME = IME_DISABLE;
    REG_IE = 0;
    REG_IF = ~0;

    IPC8->IPC_ARM7 = IPC_MSG_ARM7_READY_BOOT;
}

extern void main_InitIRQ(void);
extern __attribute__((noinline))  void main_Proc_strpcmControl(void);
int main(int argc, char ** argv)
{

    arm7strwrite=0;
    arm7strread=0;
    arm7strindex = arm7strindexaddr;
    memset((char*)arm7strindexaddr,0,arm7strindexnum*4);
    memset((char*)arm7strbeginaddr,0,arm7strlen);

	// read User Settings from firmware
	readUserSettings();
    rtcReset();
    /*
    swiDelay(0x1000);
    IPC8->IPC_ARM7=IPC_MSG_BOOTWAIT;
    while( IPC8->IPC_ARM7 != IPC_MSG_NONE ) {
        swiDelay(0x100);
    }
    */

    strpcmL[0] =(u8*)(0x6000000);//(u8*)&arm7_audio_buf[0];//(u8*) 0x6000000;// (u8*)&arm7_audio_buf[0];//1ffff
    strpcmL[1] =(u8*)(0x6000000 + 32768);//(u8*)&arm7_audio_buf[16384/4];//(u8*)( 0x6000000 + 16384);//(u8*)&arm7_audio_buf[16384/4];
    strpcmR[0] =(u8*)(0x6000000 + (2*32768));//(u8*)&arm7_audio_buf[(16384*2)/4];//(u8*) ( 0x6000000 + (2*16384));// (u8*)&arm7_audio_buf[(16384*2)/4];
    strpcmR[1] =(u8*)(0x6000000 + (3*32768));//(u8*)&arm7_audio_buf[(16384*3)/4];//(u8*)(  0x6000000 + (3*16384));// (u8*)&arm7_audio_buf[(16384*3)/4];


    //enable sound
	irqInit();
    main_InitIRQ();

	SetYtrigger(80);

    l_vol = 0x7f ;
    r_vol = 0x7f;
    mix_vol =0x7f;
    strpcmVolume64=0;


    IPC8->brightness=getBrightness();
    IPC8->Powermanagement=getPowermanagement();
    IPC8->arm9_Vblank=0;
    IPC8->ipc_arm7_w_busy=0;
    IPC8->ipc_arm9_r_busy=0;

    VcountHandler();
    // Keep the ARM7 out of main RAM
    while( true )
    {
        //swiWaitForVBlank();
        if(IPC6->strpcmControl!=ESC_NOP){
            REG_IME=0;
            main_Proc_strpcmControl(); 
            REG_IME=1;
        }
        if (IPC8->arm9_Vblank == 1)
        {
            VcountHandler();
            IPC8->arm9_Vblank=0;
        }

        vu32 ipc_msg = IPC8->IPC_ARM9;
        switch( ipc_msg )
        {
        case IPC_MSG_ARM7_REBOOT:
            {
#ifdef ENABLE_DEBUG
                _consolePrintf("IPC_MSG_ARM7_REBOOT\n");
#endif
                vu32 var_27ffe08 = *(vu32 *)0x027FFE08;
                vu32 arm9Dest = *(vu32 *)0x027FFE24;
                prepairReset();
                waitMs( 100 ); // wait ARM9 Reset

                *(vu32 *)0x027FFE24 = arm9Dest;        // let arm9 go
                waitMs( 10 );                        // !!!! wait ARM9 code ldr pc, #0x027ffe24 run !!!!
                *(vu32 *)0x027FFE08 = var_27ffe08;    // !!!! this will overwrite ARM9 code ldr pc, #0x027ffe24 !!!!
                swiSoftReset();
                break;
            }
        case IPC_MSG_SET_BRIGHTNESS:
            {
#ifdef ENABLE_DEBUG
                _consolePrintf("IPC_MSG_SET_BRIGHTNESS\n");
#endif
                u8 level = (u8 )(IPC8->IPC_ARM9_P1 & 0xff) & 3;
                IPC8->brightness=level;
                setBrightness( level );
                IPC8->IPC_ARM9 = IPC_MSG_NONE;
                break;
            }
        case IPC_MSG_GET_BRIGHTNESS:
            {
#ifdef ENABLE_DEBUG
                _consolePrintf("IPC_MSG_GET_BRIGHTNESS\n");
#endif
                u8 level = getBrightness();
                IPC8->IPC_ARM9_P1 = level;
                IPC8->IPC_ARM9 = IPC_MSG_NONE;
                break;
            }
        case IPC_MSG_SUSPEND:
            {
#ifdef ENABLE_DEBUG
                _consolePrintf("IPC_MSG_SUSPEND\n");
#endif
                suspend();
            }
            break;
        case IPC_MSG_WAKEUP:
            {
#ifdef ENABLE_DEBUG
                _consolePrintf("IPC_MSG_WAKEUP\n");
#endif
                wakeup();
            }
            break;
        //case IPC_MSG_SETAUDIOTIME:
        //    {
        //        //enable_audio(IPC8->IPC_ARM9_P1,IPC8->IPC8->IPC_ARM9_P2);
        //        //strpcmPlay(IPC8->IPC_ARM9_P1,IPC8->IPC8->IPC_ARM9_P2);
        //
        //        IPC8->IPC_ARM9 = IPC_MSG_NONE;
        //
        //    }
        //    break;
        case IPC_MSG_SETAUDIOVOL:
            {
#ifdef ENABLE_DEBUG
                _consolePrintf("IPC_MSG_SETAUDIOVOL\n");
#endif
                set_audio_vol(IPC8->IPC_ARM9_P1);
                IPC8->IPC_ARM9 = IPC_MSG_NONE;
            }
            break;

        case IPC_MSG_SETSHUTDOWN :
            {
#ifdef ENABLE_DEBUG
                _consolePrintf("IPC_MSG_SETSHUTDOWN\n");
#endif
                ShutDown();
                while(1);
            }
            break;
        case IPC_MSG_SETBACKLIGHT:
            {
#ifdef ENABLE_DEBUG
                _consolePrintf("IPC_MSG_SETBACKLIGHT\n");
#endif
                IPC8->Powermanagement=getPowermanagement();
                if ((IPC8->IPC_ARM9_P1 &1) == 1)//down
                {
                    IPC8->Powermanagement |= BIT(2);
                }
                else
                {
                    IPC8->Powermanagement &= ~BIT(2);
                }

                if ((IPC8->IPC_ARM9_P1 &2) == 2)//up
                {
                    IPC8->Powermanagement |= BIT(3);
                }
                else
                {
                    IPC8->Powermanagement &= ~BIT(3);
                }
                IPC8->Powermanagement &= ~BIT(6);
                getPowermanagement(IPC8->Powermanagement);
                IPC8->IPC_ARM9 = IPC_MSG_NONE;
            }
            break;
        case IPC_MSG_BOOT_PLUGIN :
        {
	              readUserSettings();
                prepairReset();
                IPC8->IPC_ARM9 = IPC_MSG_NONE;
                IPC8->IPC_ARM9 = IPC_MSG_NONE;
                
                waitMs(200);
                int i;
                i=0;

                i = 0x03810000 - 0x300 - load_nds_rom_code_bin_size;
                swiCopy(load_nds_rom_code_bin,(char*)i,COPY_MODE_WORD | COPY_MODE_COPY |(load_nds_rom_code_bin_size/4));
                *((vu32*)0x027FFE34) = i;
                swiSoftReset();        	
        	
        }
        break;            
            
            

        default:
            {}
        }
    }
}

