/*---------------------------------------------------------------------------------


Copyright (C) 2007 Acekard, www.acekard.com

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.


---------------------------------------------------------------------------------*/





#include <nds.h>

#include "../../ipc6.h"


#include "romloader.h"
#include "loader_arm7_bin.h"
#include "loader_arm9_bin.h"
#include "../../share/ipctool.h"
#include "../../share/timetool.h"



static void resetAndLoop()
{
    // Interrupt
    REG_IME = 0;
    REG_IE = 0;
    REG_IF = ~0;

    IPC8->IPC_ARM9 = IPC_MSG_ARM7_REBOOT;

    while( IPC8->IPC_ARM7 != IPC_MSG_ARM7_READY_BOOT ) {
        swiDelay(1);
    }
    // make arm9 loop code
    *((vu32*)0x027FFE08) = (u32)0xE59FF014;  // ldr pc, 0x027FFE24
    *((vu32*)0x027FFE24) = (u32)0x027FFE08;  // Set ARM9 Loop address
    //IC_InvalidateAll();
    DC_FlushAll();
    DC_InvalidateAll();
    swiSoftReset();
}

bool loadRom( void )
{
    memset((char*)0x023b0000,0,0x23fe000-0x023b0000);
    // copy loader's arm7 code
    memcpy( (void *)0x023FA000, loader_arm7_bin, loader_arm7_bin_size );
    NDSHeader.arm7executeAddress = 0x023FA000;

    // copy loader's arm9 code
    memcpy( (void *)0x023b0000, loader_arm9_bin, loader_arm9_bin_size );
    NDSHeader.arm9executeAddress = 0x023b0000;
    resetAndLoop();
    return true;
}
