//////////////////////////////////////////////////////////////////////
//
// ipc.h -- Inter-processor communication
//
// version 0.1, February 14, 2005
//
//  Copyright (C) 2005 Michael Noland (joat) and Jason Rogers (dovoto)
//
//  This software is provided 'as-is', without any express or implied
//  warranty.  In no event will the authors be held liable for any
//  damages arising from the use of this software.
//
//  Permission is granted to anyone to use this software for any
//  purpose, including commercial applications, and to alter it and
//  redistribute it freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you
//     must not claim that you wrote the original software. If you use
//     this software in a product, an acknowledgment in the product
//     documentation would be appreciated but is not required.
//  2. Altered source versions must be plainly marked as such, and
//     must not be misrepresented as being the original software.
//  3. This notice may not be removed or altered from any source
//     distribution.
//
// Changelog:
//   0.1: First version
//
//////////////////////////////////////////////////////////////////////

#ifndef NDS_IPC6_INCLUDE
#define NDS_IPC6_INCLUDE

//////////////////////////////////////////////////////////////////////

#include <nds.h>
#define strpcmRingBufCount (4)
#define strpcmRingBufBitMask (strpcmRingBufCount-1)
#define strpcmbufmaxlen (65536)


//////////////////////////////////////////////////////////////////////

enum EstrpcmFormat {SPF_PCMx1=1,SPF_PCMx2,SPF_PCMx4};

enum EstrpcmControl {ESC_NOP=0,ESC_Play,ESC_Stop};


enum EIPCREQ {IR_NULL,IR_NextSoundData};


typedef struct sTransferRegion6 {
  
  EIPCREQ IR;
  
  EstrpcmControl strpcmControl;
  //u32 strpcmWriteRequest;
  u32 strpcmFreq,strpcmSamples,strpcmChannels;
  u32 strpcmVolume64;
  EstrpcmFormat strpcmFormat;
  s16 *strpcmLBuf,*strpcmRBuf;
  //u32 SoundChannels;

    u32 audio_buf[strpcmRingBufCount];
    u32 audio_buf_write;
    u32 audio_buf_read;
    u32 audio_enable;

} TransferRegion6, * pTransferRegion6;

//////////////////////////////////////////////////////////////////////

#define IPC6 ((TransferRegion6 volatile *)(0x027FF000+sizeof(TransferRegion)))

#define audio_buf           IPC6->audio_buf
#define audio_buf_write     IPC6->audio_buf_write
#define audio_buf_read      IPC6->audio_buf_read
#define audio_enable        IPC6->audio_enable


#endif

//////////////////////////////////////////////////////////////////////

