/*---------------------------------------------------------------------------------


Copyright (C) 2007 Acekard, www.acekard.com

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.


---------------------------------------------------------------------------------*/









#ifndef _IPC_TOOL_H_
#define _IPC_TOOL_H_
#include <nds.h>

#define IPC_MSG_NONE                    0
#define IPC_MSG_BOOT_SLOT1                1
#define IPC_MSG_BOOT_SLOT2                2
#define IPC_MSG_ARM7_READY_BOOT            3
#define IPC_MSG_LOAD_HOMEBREW            4
#define IPC_MSG_ARM7_LOAD_DONE            5
#define IPC_MSG_ARM7_REBOOT                6
#define IPC_MSG_GET_BRIGHTNESS            7
#define IPC_MSG_SET_BRIGHTNESS            8
#define IPC_MSG_SUSPEND                 9
#define IPC_MSG_WAKEUP                 10
//#define IPC_MSG_SETAUDIOTIME                 11

#define IPC_MSG_SETAUDIOVOL                 12
#define IPC_MSG_SETSHUTDOWN 13
#define IPC_MSG_SETBACKLIGHT 14
#define IPC_MSG_BOOTWAIT 15

#define IPC_MSG_BOOT_PLUGIN 18




/*
#define IPC_ARM9    (*(vu32*)0x27ff200)    //message from arm9
#define IPC_ARM9_P1 (*(vu32*)0x27ff204) // parameter 1 from arm9
#define IPC_ARM9_P2 (*(vu32*)0x27ff208) // parameter 2 from arm9

#define IPC_ARM7    (*(vu32*)0x27ff20C)    //message from arm7

u32 video_up_buf[4];
int video_up_buf_write;
int video_up_buf_read;

u32 video_down_buf[4];
int video_down_buf_write;
int video_down_buf_read;

u32 audio_l_buf[4];
int audio_l_buf_write;
int audio_l_buf_read;

u32 audio_r_buf[4];
int audio_r_buf_write;
int audio_r_buf_read;
*/

typedef struct sTransferRegion8 {
    vu32 IPC_ARM9;
    vu32 IPC_ARM9_P1;
    vu32 IPC_ARM9_P2;
    vu32 IPC_ARM7;
    int ipc_arm7_w_busy;
    int ipc_arm9_r_busy;
    int arm9_Vblank;

    vu8 brightness;
    vu8 Powermanagement;



} TransferRegion8, * pTransferRegion8;

//////////////////////////////////////////////////////////////////////

#define IPC8 ((TransferRegion8 volatile *)(0x027FF000+ sizeof(TransferRegion6) + sizeof(TransferRegion)))

//#define arm7strchange (*(vu32*)0x027Fe000)
#define arm7strwrite  (*(vu32*)0x027Fe004)
#define arm7strread   (*(vu32*)0x027Fe008)
#define arm7strindex   (*(vu32*)0x027Fe00c)
#define arm7strindexaddr   (0x027Fe010)
#define arm7strindexnum   (32)
#define arm7strindexmask   (arm7strindexnum-1)



#define arm7strbeginaddr (0x027Fe010 + (arm7strindexnum*4))
#define arm7strlen 0x400

#endif//_IPC_TOOL_H_

